/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;

public class InterruptibleIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Callable<Boolean> interrupt;
    private boolean promisedNext = false;

    @Override
    public boolean hasNext() {
        try {
            if (this.promisedNext || this.iterator.hasNext() && !this.interrupt.call().booleanValue()) {
                this.promisedNext = true;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.promisedNext = false;
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public InterruptibleIterator(Iterator<T> iterator, Callable<Boolean> interrupt) {
        this.iterator = iterator;
        this.interrupt = interrupt;
    }
}

