/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import org.apache.gobblin.broker.EmptyKey;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.util.io.MeteredInputStream;
import org.apache.gobblin.util.io.StreamCopierSharedLimiterKey;
import org.apache.gobblin.util.io.ThrottledInputStream;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.MultiLimiter;
import org.apache.gobblin.util.limiter.NoopLimiter;
import org.apache.gobblin.util.limiter.broker.SharedLimiterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamThrottler<S extends ScopeType<S>> {
    private static final Logger log = LoggerFactory.getLogger(StreamThrottler.class);
    private final SharedResourcesBroker<S> broker;

    private ThrottledInputStream doThrottleInputStream(InputStream inputStream, URI sourceURI, URI targetURI) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"InputStream cannot be null.");
        Limiter limiter = new NoopLimiter();
        if (sourceURI != null && targetURI != null) {
            StreamCopierSharedLimiterKey key = new StreamCopierSharedLimiterKey(sourceURI, targetURI);
            try {
                limiter = new MultiLimiter(limiter, (Limiter)this.broker.getSharedResource(new SharedLimiterFactory(), (SharedResourceKey)key));
            }
            catch (NotConfiguredException nce) {
                log.warn("Could not create a Limiter for key " + key, (Throwable)nce);
            }
        } else {
            log.info("Not throttling input stream because source or target URIs are not defined.");
        }
        Optional meteredStream = MeteredInputStream.findWrappedMeteredInputStream(inputStream);
        if (!meteredStream.isPresent()) {
            meteredStream = Optional.of((Object)MeteredInputStream.builder().in(inputStream).build());
            inputStream = (InputStream)meteredStream.get();
        }
        return new ThrottledInputStream(inputStream, limiter, (MeteredInputStream)meteredStream.get());
    }

    public InputStreamThrottler throttleInputStream() {
        return new InputStreamThrottler();
    }

    public StreamThrottler(SharedResourcesBroker<S> broker) {
        this.broker = broker;
    }

    public class InputStreamThrottler {
        private InputStream inputStream;
        private URI sourceURI;
        private URI targetURI;

        InputStreamThrottler() {
        }

        public InputStreamThrottler inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public InputStreamThrottler sourceURI(URI sourceURI) {
            this.sourceURI = sourceURI;
            return this;
        }

        public InputStreamThrottler targetURI(URI targetURI) {
            this.targetURI = targetURI;
            return this;
        }

        public ThrottledInputStream build() {
            return StreamThrottler.this.doThrottleInputStream(this.inputStream, this.sourceURI, this.targetURI);
        }

        public String toString() {
            return "StreamThrottler.InputStreamThrottler(inputStream=" + this.inputStream + ", sourceURI=" + this.sourceURI + ", targetURI=" + this.targetURI + ")";
        }
    }

    public static class Factory<S extends ScopeType<S>>
    implements SharedResourceFactory<StreamThrottler<S>, EmptyKey, S> {
        public static final String NAME = "streamThrottler";

        public String getName() {
            return NAME;
        }

        public SharedResourceFactoryResponse<StreamThrottler<S>> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, EmptyKey> config) throws NotConfiguredException {
            return new ResourceInstance<StreamThrottler<S>>(new StreamThrottler<S>(broker));
        }

        public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, EmptyKey> config) {
            return (S)broker.selfScope().getType();
        }
    }
}

