/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.function;

import java.io.IOException;
import java.util.function.Predicate;

@FunctionalInterface
public interface CheckedExceptionPredicate<T, E extends Exception> {
    public boolean test(T var1) throws E;

    public static <T, E extends Exception> Predicate<T> wrapToUnchecked(CheckedExceptionPredicate<T, E> f) {
        return a -> {
            try {
                return f.test(a);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, E extends IOException> Predicate<T> wrapToTunneled(CheckedExceptionPredicate<T, E> f) {
        return a -> {
            try {
                return f.test(a);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new WrappedIOException(ioe);
            }
        };
    }

    public static class WrappedIOException
    extends RuntimeException {
        private final IOException wrappedException;

        public void rethrowWrapped() throws IOException {
            throw this.wrappedException;
        }

        public WrappedIOException(IOException wrappedException) {
            this.wrappedException = wrappedException;
        }

        public IOException getWrappedException() {
            return this.wrappedException;
        }
    }
}

