/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.function;

import java.io.IOException;
import java.util.function.Function;

@FunctionalInterface
public interface CheckedExceptionFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    public static <T, R, E extends Exception> Function<T, R> wrapToUnchecked(CheckedExceptionFunction<T, R, E> f) {
        return a -> {
            try {
                return f.apply(a);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, R, E extends IOException> Function<T, R> wrapToTunneled(CheckedExceptionFunction<T, R, E> f) {
        return a -> {
            try {
                return f.apply(a);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new WrappedIOException(ioe);
            }
        };
    }

    public static class WrappedIOException
    extends RuntimeException {
        private final IOException wrappedException;

        public void rethrowWrapped() throws IOException {
            throw this.wrappedException;
        }

        public WrappedIOException(IOException wrappedException) {
            this.wrappedException = wrappedException;
        }

        public IOException getWrappedException() {
            return this.wrappedException;
        }
    }
}

