/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filters;

import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class RegexPathFilter
implements PathFilter {
    private final Pattern regex;
    private final boolean include;
    public static final String REGEX = "path.filter.regex";

    public RegexPathFilter(Properties props) {
        this(props.getProperty(REGEX));
    }

    public RegexPathFilter(String regex) {
        this(regex, true);
    }

    public RegexPathFilter(String regex, boolean include) {
        this.regex = Pattern.compile(regex);
        this.include = include;
    }

    public boolean accept(Path path) {
        boolean matches = this.regex.matcher(path.getName()).matches();
        return this.include ? matches : !matches;
    }

    public String toString() {
        return "RegexPathFilter(regex=" + this.regex + ", include=" + this.include + ")";
    }
}

