/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Set;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.util.filesystem.DataFileVersionStrategy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ModTimeDataFileVersionStrategy
implements DataFileVersionStrategy<Long> {
    private final FileSystem fs;

    @Override
    public Long getVersion(Path path) throws IOException {
        return this.fs.getFileStatus(path).getModificationTime();
    }

    @Override
    public boolean setVersion(Path path, Long version) {
        return false;
    }

    @Override
    public boolean setDefaultVersion(Path path) {
        return false;
    }

    @Override
    public Set<DataFileVersionStrategy.Characteristic> applicableCharacteristics() {
        return ImmutableSet.of((Object)((Object)DataFileVersionStrategy.Characteristic.COMPATIBLE_WITH_MODTIME));
    }

    public ModTimeDataFileVersionStrategy(FileSystem fs) {
        this.fs = fs;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModTimeDataFileVersionStrategy)) {
            return false;
        }
        ModTimeDataFileVersionStrategy other = (ModTimeDataFileVersionStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileSystem this$fs = this.getFs();
        FileSystem other$fs = other.getFs();
        return !(this$fs == null ? other$fs != null : !this$fs.equals(other$fs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModTimeDataFileVersionStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileSystem $fs = this.getFs();
        result = result * 59 + ($fs == null ? 43 : $fs.hashCode());
        return result;
    }

    public String toString() {
        return "ModTimeDataFileVersionStrategy(fs=" + this.getFs() + ")";
    }

    @Alias(value="modtime")
    public static class Factory
    implements DataFileVersionStrategy.DataFileVersionFactory<Long> {
        @Override
        public DataFileVersionStrategy<Long> createDataFileVersionStrategy(FileSystem fs, Config config) {
            return new ModTimeDataFileVersionStrategy(fs);
        }
    }
}

