/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.filesystem.PathAlterationListener;
import org.apache.gobblin.util.filesystem.PathAlterationObserver;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCatchingPathAlterationListenerDecorator
implements PathAlterationListener,
Decorator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionCatchingPathAlterationListenerDecorator.class);
    private final PathAlterationListener underlying;

    public Object getDecoratedObject() {
        return this.underlying;
    }

    @Override
    public void onStart(PathAlterationObserver observer) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onStart(observer);
            return null;
        });
    }

    @Override
    public void onFileCreate(Path path) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onFileCreate(path);
            return null;
        });
    }

    @Override
    public void onFileChange(Path path) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onFileChange(path);
            return null;
        });
    }

    @Override
    public void onStop(PathAlterationObserver observer) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onStop(observer);
            return null;
        });
    }

    @Override
    public void onDirectoryCreate(Path directory) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onDirectoryCreate(directory);
            return null;
        });
    }

    @Override
    public void onDirectoryChange(Path directory) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onDirectoryChange(directory);
            return null;
        });
    }

    @Override
    public void onDirectoryDelete(Path directory) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onDirectoryDelete(directory);
            return null;
        });
    }

    @Override
    public void onFileDelete(Path path) {
        this.logSwallowedThrowable(() -> {
            this.underlying.onFileDelete(path);
            return null;
        });
    }

    @Override
    public void onCheckDetectedChange() {
        this.logSwallowedThrowable(() -> {
            this.underlying.onCheckDetectedChange();
            return null;
        });
    }

    protected void logSwallowedThrowable(Callable<Void> c) {
        try {
            c.call();
        }
        catch (Throwable exc) {
            String methodName = Arrays.stream(exc.getStackTrace()).findFirst().get().getMethodName();
            log.error(methodName + " failed due to exception:", exc);
        }
    }

    public ExceptionCatchingPathAlterationListenerDecorator(PathAlterationListener underlying) {
        this.underlying = underlying;
    }
}

