/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.typesafe.config.Config;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public interface DataFileVersionStrategy<T extends Comparable<T> & Serializable> {
    public static final String DATA_FILE_VERSION_STRATEGY_KEY = "org.apache.gobblin.dataFileVersionStrategy";
    public static final String DEFAULT_DATA_FILE_VERSION_STRATEGY = "modtime";

    public static DataFileVersionStrategy instantiateDataFileVersionStrategy(FileSystem fs, Config config) throws IOException {
        String versionStrategy = ConfigUtils.getString(config, DATA_FILE_VERSION_STRATEGY_KEY, DEFAULT_DATA_FILE_VERSION_STRATEGY);
        ClassAliasResolver resolver = new ClassAliasResolver(DataFileVersionFactory.class);
        try {
            Class klazz = resolver.resolveClass(versionStrategy);
            return ((DataFileVersionFactory)klazz.newInstance()).createDataFileVersionStrategy(fs, config);
        }
        catch (ReflectiveOperationException roe) {
            throw new IOException(roe);
        }
    }

    public T getVersion(Path var1) throws IOException;

    public boolean setVersion(Path var1, T var2) throws IOException;

    public boolean setDefaultVersion(Path var1) throws IOException;

    public Set<Characteristic> applicableCharacteristics();

    default public boolean hasCharacteristic(Characteristic characteristic) {
        return this.applicableCharacteristics().contains((Object)characteristic);
    }

    public static interface DataFileVersionFactory<T extends Comparable<T> & Serializable> {
        public DataFileVersionStrategy<T> createDataFileVersionStrategy(FileSystem var1, Config var2);
    }

    public static enum Characteristic {
        COMPATIBLE_WITH_MODTIME,
        SETTABLE,
        STRICT;

    }
}

