/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.concurrent;

import java.util.concurrent.TimeUnit;

public class AutoResetEvent {
    private final Object syncObject = new Object();
    private boolean state;

    public AutoResetEvent() {
        this(false);
    }

    public AutoResetEvent(boolean initialState) {
        this.state = initialState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOne() throws InterruptedException {
        Object object = this.syncObject;
        synchronized (object) {
            while (!this.state) {
                this.syncObject.wait();
            }
            this.state = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOne(int timeout, TimeUnit timeUnit) throws InterruptedException {
        long waitTime = timeUnit.toNanos(timeout);
        long startTime = System.nanoTime();
        Object object = this.syncObject;
        synchronized (object) {
            while (!this.state) {
                long remainingTimeoutNs = waitTime - (System.nanoTime() - startTime);
                if (remainingTimeoutNs <= 0L) {
                    return false;
                }
                long remainingTimeoutMs = 0L;
                if (remainingTimeoutNs > 999999L) {
                    remainingTimeoutMs = remainingTimeoutNs / 1000000L;
                    remainingTimeoutNs %= 1000000L;
                }
                this.syncObject.wait(remainingTimeoutMs, (int)remainingTimeoutNs);
            }
            this.state = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set() {
        Object object = this.syncObject;
        synchronized (object) {
            this.state = true;
            this.syncObject.notify();
        }
    }
}

