/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.callbacks;

import com.google.common.base.Preconditions;
import java.util.concurrent.Future;

public class CallbackResult<R> {
    private final R result;
    private final Throwable error;
    private final boolean canceled;

    public boolean hasFailed() {
        return null != this.error;
    }

    public boolean isSuccessful() {
        return !this.hasFailed() && !this.isCanceled();
    }

    public static <R> CallbackResult<R> createCancelled() {
        return new CallbackResult<Object>(null, null, true);
    }

    public static <R> CallbackResult<R> createFailed(Throwable t) {
        return new CallbackResult<Object>(null, t, false);
    }

    public static <R> CallbackResult<R> createSuccessful(R result) {
        return new CallbackResult<R>(result, null, false);
    }

    public static <R> CallbackResult<R> createFromFuture(Future<R> execFuture) throws InterruptedException {
        Preconditions.checkNotNull(execFuture);
        if (execFuture.isCancelled()) {
            return CallbackResult.createCancelled();
        }
        try {
            R res = execFuture.get();
            return CallbackResult.createSuccessful(res);
        }
        catch (Exception e) {
            if (execFuture.isCancelled()) {
                return CallbackResult.createCancelled();
            }
            return CallbackResult.createFailed(e.getCause());
        }
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallbackResult)) {
            return false;
        }
        CallbackResult other = (CallbackResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCanceled() != other.isCanceled()) {
            return false;
        }
        R this$result = this.getResult();
        R other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Throwable this$error = this.getError();
        Throwable other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallbackResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCanceled() ? 79 : 97);
        R $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Throwable $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "CallbackResult(result=" + this.getResult() + ", error=" + this.getError() + ", canceled=" + this.isCanceled() + ")";
    }

    public CallbackResult(R result, Throwable error, boolean canceled) {
        this.result = result;
        this.error = error;
        this.canceled = canceled;
    }
}

