/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerSecureSocketFactory
extends SSLSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TrustManagerSecureSocketFactory.class);
    private SSLSocketFactory sslSocketFactory;
    private String[] ciphers;
    private String protocol;

    public TrustManagerSecureSocketFactory() {
        this(null, null);
    }

    public TrustManagerSecureSocketFactory(String[] ciphers, String protocol) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            this.sslSocketFactory = ctx.getSocketFactory();
            this.ciphers = null == ciphers ? this.sslSocketFactory.getSupportedCipherSuites() : ciphers;
            this.protocol = null == protocol ? ctx.getProtocol() : protocol;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Issue in initializing TrustManagerSecureSocketFactory.", e);
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(s, host, port, autoClose), new Object[]{host, port});
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(host, port), new Object[]{host, port});
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(host, port, localHost, localPort), new Object[]{host, port});
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(host, port), new Object[]{host, port});
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(address, port, localAddress, localPort), new Object[]{address, port});
    }

    private Socket enableCipherSuites(Socket s, Object[] logParams) {
        String[] p;
        SSLSocket socket = (SSLSocket)s;
        if (socket == null) {
            LOG.warn("PROBLEM_CREATING_OUTBOUND_REQUEST_SOCKET", logParams);
            return null;
        }
        if (this.protocol != null && (p = this.findProtocols(this.protocol, socket.getSupportedProtocols())) != null) {
            socket.setEnabledProtocols(p);
        }
        if (this.ciphers != null) {
            socket.setEnabledCipherSuites(this.ciphers);
        }
        return socket;
    }

    private String[] findProtocols(String p, String[] options) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : options) {
            if (s.equals(p)) {
                return new String[]{p};
            }
            if (!s.startsWith(p)) continue;
            list.add(s);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[0]);
    }
}

