/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeRangeChecker {
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZone.forID((String)"America/Los_Angeles");
    private static final String HOUR_MINUTE_FORMAT = "HH-mm";
    private static final DateTimeFormatter HOUR_MINUTE_FORMATTER = DateTimeFormat.forPattern((String)"HH-mm");
    private static final Map<Integer, String> DAYS_OF_WEEK = new ImmutableMap.Builder().put((Object)1, (Object)"MONDAY").put((Object)2, (Object)"TUESDAY").put((Object)3, (Object)"WEDNESDAY").put((Object)4, (Object)"THURSDAY").put((Object)5, (Object)"FRIDAY").put((Object)6, (Object)"SATURDAY").put((Object)7, (Object)"SUNDAY").build();

    public static boolean isTimeInRange(List<String> days, String startTimeStr, String endTimeStr, DateTime currentTime) {
        if (!Iterables.any(days, (Predicate)new AreDaysEqual(DAYS_OF_WEEK.get(currentTime.getDayOfWeek())))) {
            return false;
        }
        DateTime startTime = null;
        DateTime endTime = null;
        try {
            startTime = HOUR_MINUTE_FORMATTER.withZone(DATE_TIME_ZONE).parseDateTime(startTimeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("startTimeStr format is invalid, must be of format HH-mm", e);
        }
        try {
            endTime = HOUR_MINUTE_FORMATTER.withZone(DATE_TIME_ZONE).parseDateTime(endTimeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("endTimeStr format is invalid, must be of format HH-mm", e);
        }
        startTime = startTime.withDate(currentTime.getYear(), currentTime.getMonthOfYear(), currentTime.getDayOfMonth());
        endTime = endTime.withDate(currentTime.getYear(), currentTime.getMonthOfYear(), currentTime.getDayOfMonth());
        Interval interval = new Interval(startTime.getMillis(), endTime.getMillis(), DATE_TIME_ZONE);
        return interval.contains(currentTime.getMillis());
    }

    private static class AreDaysEqual
    implements Predicate<String> {
        private String day;

        public boolean apply(String day) {
            return this.day.equalsIgnoreCase(day);
        }

        public AreDaysEqual(String day) {
            this.day = day;
        }
    }
}

