/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.typesafe.config.Config;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.TrustManagerSecureSocketFactory;
import org.apache.gobblin.util.TrustManagerSocketFactory;
import org.apache.log4j.Logger;

public class LdapUtils {
    public static final String LDAP_PREFIX = "groupOwnershipService.ldap";
    public static final String LDAP_BASE_DN_KEY = "groupOwnershipService.ldap.baseDn";
    public static final String LDAP_HOST_KEY = "groupOwnershipService.ldap.host";
    public static final String LDAP_PORT_KEY = "groupOwnershipService.ldap.port";
    public static final String LDAP_USER_KEY = "groupOwnershipService.ldap.username";
    public static final String LDAP_PASSWORD_KEY = "groupOwnershipService.ldap.password";
    public static final String LDAP_USE_SECURE_TRUSTMANAGER = "groupOwnershipService.ldap.useSecureTrustManager";
    private static final Logger logger = Logger.getLogger(LdapUtils.class);
    private final String _ldapHost;
    private final String _ldapPort;
    private final String _ldapBaseDN;
    private final String _ldapUser;
    private final String _ldapPassword;
    private final boolean _ldapUseSecureTrustManager;
    private final String _personSearchFilter = "(&(objectcategory=Person)(samaccountname=%s))";
    private final String _groupSearchFilter = "(&(objectcategory=Group)(cn=%s))";
    private final String _memberSearchFilter = "(&(objectcategory=Person)(memberof=%s))";
    private final String _distinguishedName = "distinguishedName";
    private final String _samAccount = "sAMAccountName";
    private final String _memberOf = "memberof";

    public LdapUtils(Config config) {
        PasswordManager passwordManager = PasswordManager.getInstance((State)ConfigUtils.configToState(config));
        String password = passwordManager.readPassword(config.getString(LDAP_PASSWORD_KEY));
        this._ldapHost = config.getString(LDAP_HOST_KEY);
        this._ldapPort = config.getString(LDAP_PORT_KEY);
        this._ldapUser = config.getString(LDAP_USER_KEY);
        this._ldapPassword = password;
        this._ldapBaseDN = config.getString(LDAP_BASE_DN_KEY);
        this._ldapUseSecureTrustManager = config.hasPath(LDAP_USE_SECURE_TRUSTMANAGER) ? config.getBoolean(LDAP_USE_SECURE_TRUSTMANAGER) : false;
    }

    private DirContext getDirContext(String username, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", String.format("ldaps://%s:%s", this._ldapHost, this._ldapPort));
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.protocol", "ssl");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        if (this._ldapUseSecureTrustManager) {
            env.put("java.naming.ldap.factory.socket", TrustManagerSecureSocketFactory.class.getCanonicalName());
        } else {
            env.put("java.naming.ldap.factory.socket", TrustManagerSocketFactory.class.getCanonicalName());
        }
        return new InitialDirContext(env);
    }

    private NamingEnumeration<SearchResult> searchLDAP(String searchFilter, DirContext ctx) throws NamingException {
        String baseDN = this._ldapBaseDN;
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        return ctx.search(baseDN, searchFilter, controls);
    }

    private String getAttribute(SearchResult result, String attribute) throws NamingException {
        return result.getAttributes().get(attribute).get().toString();
    }

    public Set<String> getGroupMembers(String groupName) throws NamingException {
        if (this._ldapUser == null || this._ldapPassword == null) {
            throw new IllegalStateException("Username and password must be provided when initiating the class");
        }
        HashSet<String> resultSet = new HashSet<String>();
        DirContext ctx = this.getDirContext(this._ldapUser, this._ldapPassword);
        logger.info((Object)"Searching for groups");
        String searchFilter = String.format("(&(objectcategory=Group)(cn=%s))", groupName);
        NamingEnumeration<SearchResult> groupResults = this.searchLDAP(searchFilter, ctx);
        SearchResult group = groupResults.next();
        String distinguishedName = this.getAttribute(group, "distinguishedName");
        String membersSearchFilter = String.format("(&(objectcategory=Person)(memberof=%s))", distinguishedName);
        logger.info((Object)"Searching for members");
        NamingEnumeration<SearchResult> members = this.searchLDAP(membersSearchFilter, ctx);
        while (members.hasMoreElements()) {
            SearchResult member = members.next();
            resultSet.add(this.getAttribute(member, "sAMAccountName"));
        }
        logger.info((Object)String.format("Members part of group %s: %s", groupName, ((Object)resultSet).toString()));
        return resultSet;
    }
}

