/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.RateControlledFileSystem;
import org.apache.gobblin.util.WriterUtils;
import org.apache.gobblin.util.deprecation.DeprecationUtils;
import org.apache.gobblin.util.executors.ScalingThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger log = LoggerFactory.getLogger(HadoopUtils.class);
    public static final String HDFS_ILLEGAL_TOKEN_REGEX = "[\\s:\\\\]";
    public static final Collection<String> FS_SCHEMES_NON_ATOMIC = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object)"s3").add((Object)"s3a").add((Object)"s3n").build();
    public static final String MAX_FILESYSTEM_QPS = "filesystem.throttling.max.filesystem.qps";
    private static final List<String> DEPRECATED_KEYS = Lists.newArrayList((Object[])new String[]{"gobblin.copy.max.filesystem.qps"});
    private static final int MAX_RENAME_TRIES = 3;

    public static Configuration newConfiguration() {
        Configuration conf = new Configuration();
        String awsAccessKeyId = System.getenv("AWS_ACCESS_KEY_ID");
        String awsSecretAccessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        if (awsAccessKeyId != null && awsSecretAccessKey != null) {
            conf.set("fs.s3.awsAccessKeyId", awsAccessKeyId);
            conf.set("fs.s3.awsSecretAccessKey", awsSecretAccessKey);
            conf.set("fs.s3n.awsAccessKeyId", awsAccessKeyId);
            conf.set("fs.s3n.awsSecretAccessKey", awsSecretAccessKey);
        }
        conf.set("fs.sftp.impl", "org.apache.gobblin.source.extractor.extract.sftp.SftpLightWeightFileSystem");
        conf.set("fs.sftp.impl.disable.cache", "true");
        return conf;
    }

    @Deprecated
    public static List<FileStatus> listStatusRecursive(FileSystem fileSystem, Path path) throws IOException {
        ArrayList results = Lists.newArrayList();
        HadoopUtils.walk(results, fileSystem, path);
        return results;
    }

    public static String toUriPath(Path path) {
        return path.toUri().getPath();
    }

    public static void deletePath(FileSystem fs, Path f, boolean recursive) throws IOException {
        if (fs.exists(f) && !fs.delete(f, recursive)) {
            throw new IOException("Failed to delete: " + f);
        }
    }

    public static void deleteDirectories(FileSystem fs, List<String> directoriesToDelete, boolean recursive, boolean moveToTrash) throws IOException {
        for (String directory : directoriesToDelete) {
            if (moveToTrash) {
                HadoopUtils.moveToTrash(fs, new Path(directory));
                continue;
            }
            HadoopUtils.deletePath(fs, new Path(directory), recursive);
        }
    }

    public static void deleteIfExists(FileSystem fs, Path path, boolean recursive) throws IOException {
        if (fs.exists(path)) {
            HadoopUtils.deletePath(fs, path, recursive);
        }
    }

    public static void deletePathAndEmptyAncestors(FileSystem fs, Path f, boolean recursive) throws IOException {
        HadoopUtils.deletePath(fs, f, recursive);
        for (Path parent = f.getParent(); parent != null && fs.exists(parent) && fs.listStatus(parent).length == 0; parent = parent.getParent()) {
            HadoopUtils.deletePath(fs, parent, true);
        }
    }

    public static void deletePathByRegex(FileSystem fs, Path path, String regex) throws IOException {
        FileStatus[] statusList;
        for (FileStatus oldJobFile : statusList = fs.listStatus(path, path1 -> path1.getName().matches(regex))) {
            HadoopUtils.deletePath(fs, oldJobFile.getPath(), true);
        }
    }

    public static void moveToTrash(FileSystem fs, Path path) throws IOException {
        HadoopUtils.moveToTrash(fs, path, new Configuration());
    }

    public static void moveToTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    public static boolean renamePathHandleLocalFSRace(FileSystem fs, Path src, Path dst) throws IOException {
        if (DecoratorUtils.resolveUnderlyingObject((Object)fs) instanceof LocalFileSystem && fs.isDirectory(src)) {
            LocalFileSystem localFs = (LocalFileSystem)DecoratorUtils.resolveUnderlyingObject((Object)fs);
            File srcFile = localFs.pathToFile(src);
            File dstFile = localFs.pathToFile(dst);
            return srcFile.renameTo(dstFile);
        }
        return fs.rename(src, dst);
    }

    public static void renamePath(FileContext fc, Path oldName, Path newName) throws IOException {
        HadoopUtils.renamePath(fc, oldName, newName, false);
    }

    public static void renamePath(FileContext fc, Path oldName, Path newName, boolean overwrite) throws IOException {
        Options.Rename renameOptions = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
        fc.rename(oldName, newName, new Options.Rename[]{renameOptions});
    }

    public static void renamePath(FileSystem fs, Path oldName, Path newName) throws IOException {
        HadoopUtils.renamePath(fs, oldName, newName, false);
    }

    public static void renamePath(FileSystem fs, Path oldName, Path newName, boolean overwrite) throws IOException {
        HadoopUtils.renamePath(fs, oldName, newName, overwrite, new Configuration());
    }

    public static void renamePath(FileSystem fs, Path oldName, Path newName, boolean overwrite, Configuration conf) throws IOException {
        if (fs instanceof DistributedFileSystem) {
            Options.Rename renameOptions = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
            ((DistributedFileSystem)fs).rename(oldName, newName, new Options.Rename[]{renameOptions});
        } else {
            if (!fs.exists(oldName)) {
                throw new FileNotFoundException(String.format("Failed to rename %s to %s: src not found", oldName, newName));
            }
            if (fs.exists(newName)) {
                if (overwrite) {
                    HadoopUtils.moveToTrash(fs, newName, conf);
                } else {
                    throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s: dst already exists", oldName, newName));
                }
            }
            if (!fs.rename(oldName, newName)) {
                throw new IOException(String.format("Failed to rename %s to %s", oldName, newName));
            }
        }
    }

    public static void movePath(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, Configuration conf) throws IOException {
        HadoopUtils.movePath(srcFs, src, dstFs, dst, false, conf);
    }

    public static void movePath(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, boolean overwrite, Configuration conf) throws IOException {
        if (srcFs.getUri().getScheme().equals(dstFs.getUri().getScheme()) && !FS_SCHEMES_NON_ATOMIC.contains(srcFs.getUri().getScheme()) && !FS_SCHEMES_NON_ATOMIC.contains(dstFs.getUri().getScheme())) {
            HadoopUtils.renamePath(srcFs, src, dst);
        } else {
            HadoopUtils.copyPath(srcFs, src, dstFs, dst, true, overwrite, conf);
        }
    }

    public static void copyPath(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, Configuration conf) throws IOException {
        HadoopUtils.copyPath(srcFs, src, dstFs, dst, false, false, conf);
    }

    public static void copyPath(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, boolean overwrite, Configuration conf) throws IOException {
        HadoopUtils.copyPath(srcFs, src, dstFs, dst, false, overwrite, conf);
    }

    private static void copyPath(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        block8: {
            Preconditions.checkArgument((boolean)srcFs.exists(src), (Object)String.format("Cannot copy from %s to %s because src does not exist", src, dst));
            Preconditions.checkArgument((overwrite || !dstFs.exists(dst) ? 1 : 0) != 0, (Object)String.format("Cannot copy from %s to %s because dst exists", src, dst));
            try {
                boolean isSourceFileSystemLocal;
                boolean bl = isSourceFileSystemLocal = srcFs instanceof LocalFileSystem || srcFs instanceof RawLocalFileSystem;
                if (isSourceFileSystemLocal) {
                    try {
                        dstFs.copyFromLocalFile(deleteSource, overwrite, src, dst);
                        break block8;
                    }
                    catch (IOException e) {
                        throw new IOException(String.format("Failed to copy %s to %s", src, dst), e);
                    }
                }
                if (!FileUtil.copy((FileSystem)srcFs, (Path)src, (FileSystem)dstFs, (Path)dst, (boolean)deleteSource, (boolean)overwrite, (Configuration)conf)) {
                    throw new IOException(String.format("Failed to copy %s to %s", src, dst));
                }
            }
            catch (Throwable t1) {
                try {
                    HadoopUtils.deleteIfExists(dstFs, dst, true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw t1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, Path tmp, boolean overwriteDst, Configuration conf) throws IOException {
        Preconditions.checkArgument((boolean)srcFs.isFile(src), (Object)String.format("Cannot copy from %s to %s because src is not a file", src, dst));
        if (FS_SCHEMES_NON_ATOMIC.contains(srcFs.getUri().getScheme()) || FS_SCHEMES_NON_ATOMIC.contains(dstFs.getUri().getScheme())) {
            HadoopUtils.copyFile(srcFs, src, dstFs, dst, overwriteDst, conf);
        } else {
            HadoopUtils.copyFile(srcFs, src, dstFs, tmp, overwriteDst, conf);
            try {
                boolean renamed = false;
                if (overwriteDst && dstFs.exists(dst)) {
                    try {
                        HadoopUtils.deletePath(dstFs, dst, true);
                    }
                    finally {
                        HadoopUtils.renamePath(dstFs, tmp, dst);
                        renamed = true;
                    }
                }
                if (!renamed) {
                    HadoopUtils.renamePath(dstFs, tmp, dst);
                }
            }
            finally {
                HadoopUtils.deletePath(dstFs, tmp, true);
            }
        }
    }

    public static void copyFile(FileSystem srcFs, Path src, FileSystem dstFs, Path dst, boolean overwrite, Configuration conf) throws IOException {
        Preconditions.checkArgument((boolean)srcFs.isFile(src), (Object)String.format("Cannot copy from %s to %s because src is not a file", src, dst));
        Preconditions.checkArgument((overwrite || !dstFs.exists(dst) ? 1 : 0) != 0, (Object)String.format("Cannot copy from %s to %s because dst exists", src, dst));
        try (FSDataInputStream in = srcFs.open(src);
             FSDataOutputStream out = dstFs.create(dst, overwrite);){
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
        }
        catch (Throwable t1) {
            try {
                HadoopUtils.deleteIfExists(dstFs, dst, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t1;
        }
    }

    private static void walk(List<FileStatus> results, FileSystem fileSystem, Path path) throws IOException {
        for (FileStatus status : fileSystem.listStatus(path)) {
            if (!status.isDirectory()) {
                results.add(status);
                continue;
            }
            HadoopUtils.walk(results, fileSystem, status.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameRecursively(FileSystem fileSystem, Path from, Path to) throws IOException {
        log.info(String.format("Recursively renaming %s in %s to %s.", from, fileSystem.getUri(), to));
        FileSystem throttledFS = HadoopUtils.getOptionallyThrottledFileSystem(fileSystem, 10000);
        ScalingThreadPoolExecutor executorService = ScalingThreadPoolExecutor.newScalingThreadPool(1, 100, 100L, ExecutorsUtils.newThreadFactory((Optional<Logger>)Optional.of((Object)log), (Optional<String>)Optional.of((Object)"rename-thread-%d")));
        ConcurrentLinkedQueue futures = Queues.newConcurrentLinkedQueue();
        try {
            if (!fileSystem.exists(from)) {
                throw new IOException("Trying to rename a path that does not exist! " + from);
            }
            futures.add(executorService.submit(new RenameRecursively(throttledFS, fileSystem.getFileStatus(from), to, executorService, futures)));
            int futuresUsed = 0;
            while (!futures.isEmpty()) {
                try {
                    ((Future)futures.poll()).get();
                    ++futuresUsed;
                }
                catch (InterruptedException | ExecutionException ee) {
                    throw new IOException(ee.getCause());
                }
            }
            log.info(String.format("Recursive renaming of %s to %s. (details: used %d futures)", from, to, futuresUsed));
        }
        finally {
            ExecutorsUtils.shutdownExecutorService(executorService, (Optional<Logger>)Optional.of((Object)log), 1L, TimeUnit.SECONDS);
        }
    }

    public static FileSystem getOptionallyThrottledFileSystem(FileSystem fs, State state) throws IOException {
        DeprecationUtils.renameDeprecatedKeys(state, MAX_FILESYSTEM_QPS, DEPRECATED_KEYS);
        if (state.contains(MAX_FILESYSTEM_QPS)) {
            return HadoopUtils.getOptionallyThrottledFileSystem(fs, state.getPropAsInt(MAX_FILESYSTEM_QPS));
        }
        return fs;
    }

    public static FileSystem getOptionallyThrottledFileSystem(FileSystem fs, int qpsLimit) throws IOException {
        if (fs instanceof Decorator) {
            for (Object obj : DecoratorUtils.getDecoratorLineage((Object)fs)) {
                if (!(obj instanceof RateControlledFileSystem)) continue;
                return fs;
            }
        }
        if (qpsLimit > 0) {
            try {
                RateControlledFileSystem newFS = new RateControlledFileSystem(fs, qpsLimit);
                newFS.startRateControl();
                return newFS;
            }
            catch (ExecutionException ee) {
                throw new IOException("Could not create throttled FileSystem.", ee);
            }
        }
        return fs;
    }

    public static synchronized boolean safeRenameIfNotExists(FileSystem fs, Path from, Path to) throws IOException {
        return HadoopUtils.unsafeRenameIfNotExists(fs, from, to);
    }

    public static boolean unsafeRenameIfNotExists(FileSystem fs, Path from, Path to) throws IOException {
        if (!fs.exists(to)) {
            if (!fs.exists(to.getParent())) {
                fs.mkdirs(to.getParent());
            }
            if (!HadoopUtils.renamePathHandleLocalFSRace(fs, from, to)) {
                if (!fs.exists(to)) {
                    throw new IOException(String.format("Failed to rename %s to %s.", from, to));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static void safeRenameRecursively(FileSystem fileSystem, Path from, Path to) throws IOException {
        for (FileStatus fromFile : FileListUtils.listFilesRecursively(fileSystem, from)) {
            Path relativeFilePath = new Path(StringUtils.substringAfter((String)fromFile.getPath().toString(), (String)(from.toString() + "/")));
            Path toFilePath = new Path(to, relativeFilePath);
            if (!fileSystem.exists(toFilePath)) {
                boolean renamed = false;
                for (int i = 0; !renamed && i < 3; ++i) {
                    try {
                        renamed = fileSystem.rename(fromFile.getPath(), toFilePath);
                        break;
                    }
                    catch (FileNotFoundException e) {
                        if (i + 1 < 3) continue;
                        throw e;
                    }
                }
                if (!renamed) {
                    throw new IOException(String.format("Failed to rename %s to %s.", fromFile.getPath(), toFilePath));
                }
                log.info(String.format("Renamed %s to %s", fromFile.getPath(), toFilePath));
                continue;
            }
            log.info(String.format("File already exists %s. Will not rewrite", toFilePath));
        }
    }

    public static Configuration getConfFromState(State state) {
        return HadoopUtils.getConfFromState(state, (Optional<String>)Optional.absent());
    }

    public static Configuration getConfFromState(State state, Optional<String> encryptedPath) {
        Config config = ConfigFactory.parseProperties((Properties)state.getProperties());
        if (encryptedPath.isPresent()) {
            config = ConfigUtils.resolveEncrypted(config, encryptedPath);
        }
        Configuration conf = HadoopUtils.newConfiguration();
        for (Map.Entry entry : config.entrySet()) {
            conf.set((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString());
        }
        return conf;
    }

    public static Configuration getConfFromProperties(Properties properties) {
        Configuration conf = HadoopUtils.newConfiguration();
        for (String propName : properties.stringPropertyNames()) {
            conf.set(propName, properties.getProperty(propName));
        }
        return conf;
    }

    public static State getStateFromConf(Configuration conf) {
        State state = new State();
        for (Map.Entry entry : conf) {
            state.setProp((String)entry.getKey(), entry.getValue());
        }
        return state;
    }

    public static void setGroup(FileSystem fs, Path path, String group) throws IOException {
        fs.setOwner(path, fs.getFileStatus(path).getOwner(), group);
    }

    /*
     * Exception decompiling
     */
    public static String serializeToString(Writable writable) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Writable deserializeFromString(Class<? extends Writable> writableClass, String serializedWritableStr) throws IOException {
        return HadoopUtils.deserializeFromString(writableClass, serializedWritableStr, new Configuration());
    }

    /*
     * Exception decompiling
     */
    public static Writable deserializeFromString(Class<? extends Writable> writableClass, String serializedWritableStr, Configuration configuration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void serializeWriterFilePermissions(State state, int numBranches, int branchId, FsPermission fsPermissions) {
        HadoopUtils.serializeFsPermissions(state, ForkOperatorUtils.getPropertyNameForBranch("writer.file.permissions", numBranches, branchId), fsPermissions);
    }

    public static void serializeWriterDirPermissions(State state, int numBranches, int branchId, FsPermission fsPermissions) {
        HadoopUtils.serializeFsPermissions(state, ForkOperatorUtils.getPropertyNameForBranch("writer.dir.permissions", numBranches, branchId), fsPermissions);
    }

    private static void serializeFsPermissions(State state, String key, FsPermission fsPermissions) {
        state.setProp(key, (Object)String.format("%04o", fsPermissions.toShort()));
    }

    public static void setWriterFileOctalPermissions(State state, int numBranches, int branchId, String octalPermissions) {
        state.setProp(ForkOperatorUtils.getPropertyNameForBranch("writer.file.permissions", numBranches, branchId), (Object)octalPermissions);
    }

    public static void setWriterDirOctalPermissions(State state, int numBranches, int branchId, String octalPermissions) {
        state.setProp(ForkOperatorUtils.getPropertyNameForBranch("writer.dir.permissions", numBranches, branchId), (Object)octalPermissions);
    }

    public static FsPermission deserializeWriterFilePermissions(State state, int numBranches, int branchId) {
        return new FsPermission(state.getPropAsShortWithRadix(ForkOperatorUtils.getPropertyNameForBranch("writer.file.permissions", numBranches, branchId), FsPermission.getDefault().toShort(), 8));
    }

    public static FsPermission deserializeWriterDirPermissions(State state, int numBranches, int branchId) {
        return new FsPermission(state.getPropAsShortWithRadix(ForkOperatorUtils.getPropertyNameForBranch("writer.dir.permissions", numBranches, branchId), FsPermission.getDefault().toShort(), 8));
    }

    public static FsPermission deserializeFsPermission(State props, String propName, FsPermission defaultPermission) {
        short mode = props.getPropAsShortWithRadix(propName, defaultPermission.toShort(), 8);
        return new FsPermission(mode);
    }

    public static String sanitizePath(String path, String substitute) {
        Preconditions.checkArgument((boolean)substitute.replaceAll(HDFS_ILLEGAL_TOKEN_REGEX, "").equals(substitute), (Object)("substitute contains illegal characters: " + substitute));
        return path.replaceAll(HDFS_ILLEGAL_TOKEN_REGEX, substitute);
    }

    public static Path sanitizePath(Path path, String substitute) {
        return new Path(HadoopUtils.sanitizePath(path.toString(), substitute));
    }

    public static void setPermissions(Path location, Optional<String> owner, Optional<String> group, FileSystem fs, FsPermission permission) {
        try {
            if (!owner.isPresent()) {
                return;
            }
            if (!group.isPresent()) {
                return;
            }
            fs.setOwner(location, (String)owner.get(), (String)group.get());
            fs.setPermission(location, permission);
            if (!fs.isDirectory(location)) {
                return;
            }
            for (FileStatus fileStatus : fs.listStatus(location)) {
                HadoopUtils.setPermissions(fileStatus.getPath(), owner, group, fs, permission);
            }
        }
        catch (IOException e) {
            log.warn("Exception occurred while trying to change permissions : " + e.getMessage());
        }
    }

    public static boolean hasContent(FileSystem fs, Path path) throws IOException {
        if (!fs.isDirectory(path)) {
            return true;
        }
        boolean content = false;
        for (FileStatus fileStatus : fs.listStatus(path)) {
            boolean bl = content = content || HadoopUtils.hasContent(fs, fileStatus.getPath());
            if (content) break;
        }
        return content;
    }

    public static void addGobblinSite() {
        Configuration.addDefaultResource((String)"gobblin-site.xml");
    }

    public static FileSystem getSourceFileSystem(State state) throws IOException {
        Configuration conf = HadoopUtils.getConfFromState(state, (Optional<String>)Optional.of((Object)"source.filebased.encrypted"));
        String uri = state.getProp("source.filebased.fs.uri", "file:///");
        return HadoopUtils.getOptionallyThrottledFileSystem(FileSystem.get((URI)URI.create(uri), (Configuration)conf), state);
    }

    public static FileSystem getWriterFileSystem(State state, int numBranches, int branchId) throws IOException {
        return HadoopUtils.getOptionallyThrottledFileSystem(WriterUtils.getWriterFS(state, numBranches, branchId), state);
    }

    private static class RenameRecursively
    implements Runnable {
        private final FileSystem fileSystem;
        private final FileStatus from;
        private final Path to;
        private final ExecutorService executorService;
        private final Queue<Future<?>> futures;

        @Override
        public void run() {
            try {
                boolean moveSucessful;
                try {
                    moveSucessful = this.from.isDirectory() ? HadoopUtils.safeRenameIfNotExists(this.fileSystem, this.from.getPath(), this.to) : HadoopUtils.unsafeRenameIfNotExists(this.fileSystem, this.from.getPath(), this.to);
                }
                catch (AccessDeniedException e) {
                    if (this.from.isDirectory()) {
                        moveSucessful = false;
                    }
                    throw e;
                }
                if (!moveSucessful) {
                    if (this.from.isDirectory()) {
                        for (FileStatus fromFile : this.fileSystem.listStatus(this.from.getPath())) {
                            Path relativeFilePath = new Path(StringUtils.substringAfter((String)fromFile.getPath().toString(), (String)(this.from.getPath().toString() + "/")));
                            Path toFilePath = new Path(this.to, relativeFilePath);
                            this.futures.add(this.executorService.submit(new RenameRecursively(this.fileSystem, fromFile, toFilePath, this.executorService, this.futures)));
                        }
                    } else {
                        log.info(String.format("File already exists %s. Will not rewrite", this.to));
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to rename " + this.from.getPath() + " to " + this.to, ioe);
            }
        }

        public RenameRecursively(FileSystem fileSystem, FileStatus from, Path to, ExecutorService executorService, Queue<Future<?>> futures) {
            this.fileSystem = fileSystem;
            this.from = from;
            this.to = to;
            this.executorService = executorService;
            this.futures = futures;
        }
    }
}

