/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Preconditions;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;

public class ForkOperatorUtils {
    public static String getPropertyNameForBranch(String key, int numBranches, int branchId) {
        Preconditions.checkArgument((numBranches >= 0 ? 1 : 0) != 0, (Object)"The number of branches is expected to be non-negative");
        Preconditions.checkArgument((branchId >= 0 ? 1 : 0) != 0, (Object)"The branchId is expected to be non-negative");
        return numBranches > 1 ? key + "." + branchId : key;
    }

    public static String getPropertyNameForBranch(String key, int branch) {
        return branch >= 0 ? key + "." + branch : key;
    }

    public static String getPropertyNameForBranch(WorkUnitState workUnitState, String key) {
        Preconditions.checkNotNull((Object)workUnitState, (Object)"Cannot get a property from a null WorkUnit");
        Preconditions.checkNotNull((Object)key, (Object)"Cannot get a the value for a null key");
        if (!workUnitState.contains("fork.branch.id")) {
            return key;
        }
        return workUnitState.getPropAsInt("fork.branch.id") >= 0 ? key + "." + workUnitState.getPropAsInt("fork.branch.id") : key;
    }

    public static String getPathForBranch(State state, String path, int numBranches, int branchId) {
        Preconditions.checkNotNull((Object)state);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((numBranches >= 0 ? 1 : 0) != 0, (Object)"The number of branches is expected to be non-negative");
        Preconditions.checkArgument((branchId >= 0 ? 1 : 0) != 0, (Object)"The branch id is expected to be non-negative");
        return numBranches > 1 ? path + "/" + state.getProp("fork.branch.name." + branchId, "fork_" + branchId) : path;
    }

    public static String getForkId(String taskId, int index) {
        return taskId + "." + index;
    }
}

