/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.ArrayUtils;
import org.apache.gobblin.util.filters.HiddenFilter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileListUtils.class);
    public static final Comparator<FileStatus> LATEST_MOD_TIME_ORDER = new Comparator<FileStatus>(){

        @Override
        public int compare(FileStatus file1, FileStatus file2) {
            return Longs.compare((long)file2.getModificationTime(), (long)file1.getModificationTime());
        }
    };
    public static final PathFilter NO_OP_PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }
    };

    public static List<FileStatus> listFilesRecursively(FileSystem fs, Path path) throws IOException {
        return FileListUtils.listFilesRecursively(fs, path, NO_OP_PATH_FILTER);
    }

    public static List<FileStatus> listFilesRecursively(FileSystem fs, Iterable<Path> paths) throws IOException {
        ArrayList results = Lists.newArrayList();
        for (Path path : paths) {
            results.addAll(FileListUtils.listFilesRecursively(fs, path));
        }
        return results;
    }

    public static List<FileStatus> listFilesToCopyAtPath(FileSystem fs, Path path, PathFilter fileFilter, boolean includeEmptyDirectories) throws IOException {
        return FileListUtils.listFilesToCopyAtPath(fs, path, fileFilter, false, includeEmptyDirectories);
    }

    public static List<FileStatus> listFilesToCopyAtPath(FileSystem fs, Path path, PathFilter fileFilter, boolean applyFilterToDirectories, boolean includeEmptyDirectories) throws IOException {
        ArrayList files = Lists.newArrayList();
        FileStatus rootFile = fs.getFileStatus(path);
        FileListUtils.listFilesRecursivelyHelper(fs, files, rootFile, fileFilter, applyFilterToDirectories, includeEmptyDirectories);
        if (files.size() == 0 && rootFile.isDirectory() && includeEmptyDirectories) {
            files.add(rootFile);
        }
        return files;
    }

    public static List<FileStatus> listFilesRecursively(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        return FileListUtils.listFilesRecursively(fs, path, fileFilter, false);
    }

    public static List<FileStatus> listFilesRecursively(FileSystem fs, Path path, PathFilter fileFilter, boolean applyFilterToDirectories) throws IOException {
        return FileListUtils.listFilesRecursivelyHelper(fs, Lists.newArrayList(), fs.getFileStatus(path), fileFilter, applyFilterToDirectories, false);
    }

    private static List<FileStatus> listFilesRecursivelyHelper(FileSystem fs, List<FileStatus> files, FileStatus fileStatus, PathFilter fileFilter, boolean applyFilterToDirectories, boolean includeEmptyDirectories) throws FileNotFoundException, IOException {
        if (fileStatus.isDirectory()) {
            for (FileStatus status : fs.listStatus(fileStatus.getPath(), applyFilterToDirectories ? fileFilter : NO_OP_PATH_FILTER)) {
                if (status.isDirectory()) {
                    int numFilesBefore = files.size();
                    FileListUtils.listFilesRecursivelyHelper(fs, files, status, fileFilter, applyFilterToDirectories, includeEmptyDirectories);
                    int numFilesAfter = files.size();
                    if (numFilesAfter != numFilesBefore || !includeEmptyDirectories) continue;
                    files.add(status);
                    continue;
                }
                FileListUtils.listFilesRecursivelyHelper(fs, files, status, fileFilter, applyFilterToDirectories, includeEmptyDirectories);
            }
        } else if (fileFilter.accept(fileStatus.getPath())) {
            files.add(fileStatus);
        }
        return files;
    }

    public static List<FileStatus> listMostNestedPathRecursively(FileSystem fs, Path path) throws IOException {
        return FileListUtils.listMostNestedPathRecursively(fs, path, NO_OP_PATH_FILTER);
    }

    public static List<FileStatus> listMostNestedPathRecursively(FileSystem fs, Iterable<Path> paths) throws IOException {
        ArrayList results = Lists.newArrayList();
        for (Path path : paths) {
            results.addAll(FileListUtils.listMostNestedPathRecursively(fs, path));
        }
        return results;
    }

    public static List<FileStatus> listMostNestedPathRecursively(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        return FileListUtils.listMostNestedPathRecursivelyHelper(fs, Lists.newArrayList(), fs.getFileStatus(path), fileFilter);
    }

    private static List<FileStatus> listMostNestedPathRecursivelyHelper(FileSystem fs, List<FileStatus> files, FileStatus fileStatus, PathFilter fileFilter) throws IOException {
        if (fileStatus.isDirectory()) {
            Object[] curFileStatus = fs.listStatus(fileStatus.getPath());
            if (ArrayUtils.isEmpty((Object[])curFileStatus)) {
                files.add(fileStatus);
            } else {
                for (Object status : curFileStatus) {
                    FileListUtils.listMostNestedPathRecursivelyHelper(fs, files, (FileStatus)status, fileFilter);
                }
            }
        } else if (fileFilter.accept(fileStatus.getPath())) {
            files.add(fileStatus);
        }
        return files;
    }

    public static List<FileStatus> listPathsRecursively(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        return FileListUtils.listPathsRecursivelyHelper(fs, Lists.newArrayList(), fs.getFileStatus(path), fileFilter);
    }

    private static List<FileStatus> listPathsRecursivelyHelper(FileSystem fs, List<FileStatus> files, FileStatus fileStatus, PathFilter fileFilter) {
        if (fileFilter.accept(fileStatus.getPath())) {
            files.add(fileStatus);
        }
        if (fileStatus.isDirectory()) {
            try {
                for (FileStatus status : fs.listStatus(fileStatus.getPath())) {
                    FileListUtils.listPathsRecursivelyHelper(fs, files, status, fileFilter);
                }
            }
            catch (IOException ioe) {
                LOG.error("Could not list contents of path " + fileStatus.getPath());
            }
        }
        return files;
    }

    public static FileStatus getAnyNonHiddenFile(FileSystem fs, Path path) throws IOException {
        HiddenFilter hiddenFilter = new HiddenFilter();
        FileStatus root = fs.getFileStatus(path);
        if (!root.isDirectory()) {
            return hiddenFilter.accept(path) ? root : null;
        }
        Stack<FileStatus> folders = new Stack<FileStatus>();
        folders.push(root);
        while (!folders.empty()) {
            FileStatus curFolder = (FileStatus)folders.pop();
            try {
                for (FileStatus status : fs.listStatus(curFolder.getPath(), (PathFilter)hiddenFilter)) {
                    if (!status.isDirectory()) {
                        return status;
                    }
                    folders.push(status);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }
}

