/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;

public abstract class Either<S, T> {
    protected final Optional<S> s;
    protected final Optional<T> t;

    public static <S, T> Either<S, T> left(S left) {
        return new Left(left);
    }

    public static <S, T> Either<S, T> right(T right) {
        return new Right(right);
    }

    public Object get() {
        if (this instanceof Left) {
            return this.s.orNull();
        }
        return this.t.orNull();
    }

    private Either(Optional<S> s, Optional<T> t) {
        this.s = s;
        this.t = t;
    }

    public static class Right<S, T>
    extends Either<S, T> {
        public Right(T t) {
            super(Optional.absent(), Optional.fromNullable(t));
        }

        public T getRight() {
            return (T)this.t.orNull();
        }
    }

    public static class Left<S, T>
    extends Either<S, T> {
        public Left(S s) {
            super(Optional.fromNullable(s), Optional.absent());
        }

        public S getLeft() {
            return (S)this.s.orNull();
        }
    }
}

