/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.util.Utf8;
import org.apache.commons.math3.util.Pair;
import org.apache.gobblin.util.AvroSchemaUtils;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroUtils {
    private static final Logger log = LoggerFactory.getLogger(AvroUtils.class);
    private static final Logger LOG = LoggerFactory.getLogger(AvroUtils.class);
    public static final String FIELD_LOCATION_DELIMITER = ".";
    public static final String AVRO_SUFFIX = ".avro";
    public static final String SCHEMA_CREATION_TIME_KEY = "CreatedOn";

    public static boolean checkReaderWriterCompatibility(Schema readerSchema, Schema writerSchema, boolean ignoreNamespace) {
        if (ignoreNamespace) {
            List<Schema.Field> fields = AvroUtils.deepCopySchemaFields(readerSchema);
            readerSchema = Schema.createRecord((String)writerSchema.getName(), (String)writerSchema.getDoc(), (String)writerSchema.getNamespace(), (boolean)readerSchema.isError());
            readerSchema.setFields(fields);
        }
        return SchemaCompatibility.checkReaderWriterCompatibility((Schema)readerSchema, (Schema)writerSchema).getType().equals((Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE);
    }

    public static Schema addSchemaCreationTime(Schema inputSchema, Schema outputSchema) {
        if (inputSchema.getProp(SCHEMA_CREATION_TIME_KEY) != null && outputSchema.getProp(SCHEMA_CREATION_TIME_KEY) == null) {
            outputSchema.addProp(SCHEMA_CREATION_TIME_KEY, inputSchema.getProp(SCHEMA_CREATION_TIME_KEY));
        }
        return outputSchema;
    }

    public static String getSchemaCreationTime(Schema inputSchema) {
        return inputSchema.getProp(SCHEMA_CREATION_TIME_KEY);
    }

    public static Schema setSchemaCreationTime(Schema inputSchema, String creationTime) {
        inputSchema.addProp(SCHEMA_CREATION_TIME_KEY, creationTime);
        return inputSchema;
    }

    public static List<Schema.Field> deepCopySchemaFields(Schema readerSchema) {
        return readerSchema.getFields().stream().map(field -> {
            Schema.Field f = AvroCompatibilityHelper.createSchemaField((String)field.name(), (Schema)field.schema(), (String)field.doc(), (Object)AvroUtils.getCompatibleDefaultValue(field), (Schema.Field.Order)field.order());
            AvroSchemaUtils.copyFieldProperties(field, f);
            return f;
        }).collect(Collectors.toList());
    }

    public static Optional<Schema> getFieldSchema(Schema schema, String fieldLocation) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fieldLocation) ? 1 : 0) != 0);
        Splitter splitter = Splitter.on((String)FIELD_LOCATION_DELIMITER).omitEmptyStrings().trimResults();
        ArrayList pathList = Lists.newArrayList((Iterable)splitter.split((CharSequence)fieldLocation));
        if (pathList.size() == 0) {
            return Optional.absent();
        }
        return AvroUtils.getFieldSchemaHelper(schema, pathList, 0);
    }

    private static Optional<Schema> getFieldSchemaHelper(Schema schema, List<String> pathList, int field) {
        if (schema.getType() == Schema.Type.RECORD && schema.getField(pathList.get(field)) == null) {
            return Optional.absent();
        }
        switch (schema.getType()) {
            case UNION: {
                if (AvroSerdeUtils.isNullableType((Schema)schema)) {
                    return AvroUtils.getFieldSchemaHelper(AvroSerdeUtils.getOtherTypeFromNullableType((Schema)schema), pathList, field);
                }
                throw new AvroRuntimeException("Union of complex types cannot be handled : " + schema);
            }
            case MAP: {
                if (field + 1 == pathList.size()) {
                    return Optional.fromNullable((Object)schema.getValueType());
                }
                return AvroUtils.getFieldSchemaHelper(schema.getValueType(), pathList, ++field);
            }
            case RECORD: {
                if (field + 1 == pathList.size()) {
                    return Optional.fromNullable((Object)schema.getField(pathList.get(field)).schema());
                }
                return AvroUtils.getFieldSchemaHelper(schema.getField(pathList.get(field)).schema(), pathList, ++field);
            }
        }
        throw new AvroRuntimeException("Invalid type in schema : " + schema);
    }

    public static Optional<Schema.Field> getField(Schema schema, String fieldLocation) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fieldLocation) ? 1 : 0) != 0);
        Splitter splitter = Splitter.on((String)FIELD_LOCATION_DELIMITER).omitEmptyStrings().trimResults();
        ArrayList pathList = Lists.newArrayList((Iterable)splitter.split((CharSequence)fieldLocation));
        if (pathList.size() == 0) {
            return Optional.absent();
        }
        return AvroUtils.getFieldHelper(schema, pathList, 0);
    }

    private static Optional<Schema.Field> getFieldHelper(Schema schema, List<String> pathList, int field) {
        Schema.Field curField = schema.getField(pathList.get(field));
        if (field + 1 == pathList.size()) {
            return Optional.fromNullable((Object)curField);
        }
        Schema fieldSchema = curField.schema();
        switch (fieldSchema.getType()) {
            case UNION: {
                throw new AvroRuntimeException("Union of complex types cannot be handled : " + schema);
            }
            case MAP: {
                return AvroUtils.getFieldHelper(fieldSchema.getValueType(), pathList, ++field);
            }
            case RECORD: {
                return AvroUtils.getFieldHelper(fieldSchema, pathList, ++field);
            }
            case ARRAY: {
                return AvroUtils.getFieldHelper(fieldSchema.getElementType(), pathList, ++field);
            }
        }
        throw new AvroRuntimeException("Invalid type " + fieldSchema.getType() + " in schema : " + schema);
    }

    public static Optional<Object> getFieldValue(GenericRecord record, String fieldLocation) {
        Map<String, Object> ret = AvroUtils.getMultiFieldValue(record, fieldLocation);
        return Optional.fromNullable((Object)ret.get(fieldLocation));
    }

    public static Map<String, Object> getMultiFieldValue(GenericRecord record, String fieldLocation) {
        Preconditions.checkNotNull((Object)record);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fieldLocation) ? 1 : 0) != 0);
        Splitter splitter = Splitter.on((String)FIELD_LOCATION_DELIMITER).omitEmptyStrings().trimResults();
        List pathList = splitter.splitToList((CharSequence)fieldLocation);
        if (pathList.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        AvroUtils.getFieldHelper(retVal, record, pathList, 0);
        return retVal;
    }

    private static void getFieldHelper(Map<String, Object> retVal, Object data, List<String> pathList, int field) {
        if (data == null) {
            return;
        }
        if (field + 1 == pathList.size()) {
            Object val = null;
            Joiner joiner = Joiner.on((String)FIELD_LOCATION_DELIMITER);
            String key = joiner.join(pathList.iterator());
            val = data instanceof Map ? AvroUtils.getObjectFromMap((Map)data, pathList.get(field)) : (data instanceof List ? AvroUtils.getObjectFromArray((List)data, Integer.parseInt(pathList.get(field))) : ((GenericRecord)data).get(pathList.get(field)));
            if (val != null) {
                retVal.put(key, val);
            }
            return;
        }
        if (data instanceof Map) {
            AvroUtils.getFieldHelper(retVal, AvroUtils.getObjectFromMap((Map)data, pathList.get(field)), pathList, ++field);
            return;
        }
        if (data instanceof List) {
            if (pathList.get(field).trim().equals("*")) {
                List arr = (List)data;
                Iterator it = arr.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Object val = it.next();
                    ArrayList<String> newPathList = new ArrayList<String>(pathList);
                    newPathList.set(field, String.valueOf(i));
                    AvroUtils.getFieldHelper(retVal, val, newPathList, field + 1);
                    ++i;
                }
            } else {
                AvroUtils.getFieldHelper(retVal, AvroUtils.getObjectFromArray((List)data, Integer.parseInt(pathList.get(field))), pathList, ++field);
            }
            return;
        }
        AvroUtils.getFieldHelper(retVal, ((GenericRecord)data).get(pathList.get(field)), pathList, ++field);
    }

    public static Map<String, String> toStringMap(Object map) {
        if (map == null) {
            return null;
        }
        if (map instanceof Map) {
            Map rawMap = (Map)map;
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry entry : rawMap.entrySet()) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return stringMap;
        }
        throw new AvroRuntimeException("value must be a map");
    }

    private static Object getObjectFromMap(Map map, String key) {
        Utf8 utf8Key = new Utf8(key);
        Object value = map.get(utf8Key);
        if (value == null) {
            return map.get(key);
        }
        return value;
    }

    private static Object getObjectFromArray(List array, int index) {
        return array.get(index);
    }

    public static GenericRecord convertRecordSchema(GenericRecord record, Schema newSchema) throws IOException {
        if (record.getSchema().equals((Object)newSchema)) {
            return record;
        }
        try {
            BinaryDecoder decoder = new DecoderFactory().binaryDecoder(AvroUtils.recordToByteArray(record), null);
            GenericDatumReader reader = new GenericDatumReader(record.getSchema(), newSchema);
            return (GenericRecord)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new IOException(String.format("Cannot convert avro record to new schema. Original schema = %s, new schema = %s", record.getSchema(), newSchema), e);
        }
    }

    public static byte[] recordToByteArray(GenericRecord record) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byteArray;
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
            GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
            writer.write((Object)record, (Encoder)encoder);
            byte[] byArray = byteArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static Schema getSchemaFromDataFile(Path dataFile, FileSystem fs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Schema parseSchemaFromFile(Path filePath, FileSystem fs) throws IOException {
        Preconditions.checkArgument((boolean)fs.exists(filePath), (Object)(filePath + " does not exist"));
        try (FSDataInputStream in = fs.open(filePath);){
            Schema schema = new Schema.Parser().parse((InputStream)in);
            return schema;
        }
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, FileSystem fs, boolean overwrite) throws IOException {
        AvroUtils.writeSchemaToFile(schema, filePath, null, fs, overwrite);
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, Path tempFilePath, FileSystem fs, boolean overwrite) throws IOException {
        AvroUtils.writeSchemaToFile(schema, filePath, tempFilePath, fs, overwrite, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.READ));
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, FileSystem fs, boolean overwrite, FsPermission perm) throws IOException {
        AvroUtils.writeSchemaToFile(schema, filePath, null, fs, overwrite, perm);
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, Path tempFilePath, FileSystem fs, boolean overwrite, FsPermission perm) throws IOException {
        boolean fileExists = fs.exists(filePath);
        if (!overwrite) {
            Preconditions.checkState((!fileExists ? 1 : 0) != 0, (Object)(filePath + " already exists"));
        } else if (fileExists && null == tempFilePath) {
            HadoopUtils.deletePath(fs, filePath, true);
            fileExists = false;
        }
        Path writeFilePath = fileExists ? tempFilePath : filePath;
        try (FSDataOutputStream dos = fs.create(writeFilePath);){
            dos.writeChars(schema.toString());
        }
        fs.setPermission(writeFilePath, perm);
        if (fileExists) {
            if (!fs.delete(filePath, true)) {
                throw new IOException(String.format("Failed to delete %s while renaming %s to %s", filePath, tempFilePath, filePath));
            }
            HadoopUtils.movePath(fs, tempFilePath, fs, filePath, true, fs.getConf());
        }
    }

    public static Schema getDirectorySchema(Path directory, FileSystem fs, boolean latest) throws IOException {
        Schema schema = null;
        try (Closer closer = Closer.create();){
            List<FileStatus> files = AvroUtils.getDirectorySchemaHelper(directory, fs);
            if (files == null || files.size() == 0) {
                LOG.warn("There is no previous avro file in the directory: " + directory);
            } else {
                FileStatus file = latest ? files.get(0) : files.get(files.size() - 1);
                LOG.debug("Path to get the avro schema: " + file);
                FsInput fi = new FsInput(file.getPath(), fs.getConf());
                GenericDatumReader genReader = new GenericDatumReader();
                schema = ((DataFileReader)closer.register((Closeable)new DataFileReader((SeekableInput)fi, (DatumReader)genReader))).getSchema();
            }
        }
        catch (IOException ioe) {
            throw new IOException("Cannot get the schema for directory " + directory, ioe);
        }
        return schema;
    }

    public static Schema getDirectorySchema(Path directory, Configuration conf, boolean latest) throws IOException {
        return AvroUtils.getDirectorySchema(directory, FileSystem.get((Configuration)conf), latest);
    }

    private static List<FileStatus> getDirectorySchemaHelper(Path directory, FileSystem fs) throws IOException {
        ArrayList files = Lists.newArrayList();
        if (fs.exists(directory)) {
            AvroUtils.getAllNestedAvroFiles(fs.getFileStatus(directory), files, fs);
            if (files.size() > 0) {
                Collections.sort(files, FileListUtils.LATEST_MOD_TIME_ORDER);
            }
        }
        return files;
    }

    private static void getAllNestedAvroFiles(FileStatus dir, List<FileStatus> files, FileSystem fs) throws IOException {
        if (dir.isDirectory()) {
            FileStatus[] filesInDir = fs.listStatus(dir.getPath());
            if (filesInDir != null) {
                for (FileStatus f : filesInDir) {
                    AvroUtils.getAllNestedAvroFiles(f, files, fs);
                }
            }
        } else if (dir.getPath().getName().endsWith(AVRO_SUFFIX)) {
            files.add(dir);
        }
    }

    public static Schema nullifyFieldsForSchemaMerge(Schema oldSchema, Schema newSchema) {
        if (oldSchema == null) {
            LOG.warn("No previous schema available, use the new schema instead.");
            return newSchema;
        }
        if (!oldSchema.getType().equals((Object)Schema.Type.RECORD) || !newSchema.getType().equals((Object)Schema.Type.RECORD)) {
            LOG.warn("Both previous schema and new schema need to be record type. Quit merging schema.");
            return newSchema;
        }
        ArrayList combinedFields = Lists.newArrayList();
        for (Schema.Field newFld : newSchema.getFields()) {
            combinedFields.add(AvroCompatibilityHelper.createSchemaField((String)newFld.name(), (Schema)newFld.schema(), (String)newFld.doc(), (Object)AvroUtils.getCompatibleDefaultValue(newFld)));
        }
        for (Schema.Field oldFld : oldSchema.getFields()) {
            Schema newFldSchema;
            if (newSchema.getField(oldFld.name()) != null) continue;
            ArrayList union = Lists.newArrayList();
            Schema oldFldSchema = oldFld.schema();
            if (oldFldSchema.getType().equals((Object)Schema.Type.UNION)) {
                union.add(Schema.create((Schema.Type)Schema.Type.NULL));
                for (Schema itemInUion : oldFldSchema.getTypes()) {
                    if (itemInUion.getType().equals((Object)Schema.Type.NULL)) continue;
                    union.add(itemInUion);
                }
                newFldSchema = Schema.createUnion((List)union);
                combinedFields.add(AvroCompatibilityHelper.createSchemaField((String)oldFld.name(), (Schema)newFldSchema, (String)oldFld.doc(), (Object)AvroUtils.getCompatibleDefaultValue(oldFld)));
                continue;
            }
            union.add(Schema.create((Schema.Type)Schema.Type.NULL));
            union.add(oldFldSchema);
            newFldSchema = Schema.createUnion((List)union);
            Object obj = AvroUtils.getCompatibleDefaultValue(oldFld);
            combinedFields.add(AvroCompatibilityHelper.createSchemaField((String)oldFld.name(), (Schema)newFldSchema, (String)oldFld.doc(), (Object)AvroUtils.getCompatibleDefaultValue(oldFld)));
        }
        Schema mergedSchema = Schema.createRecord((String)newSchema.getName(), (String)newSchema.getDoc(), (String)newSchema.getNamespace(), (boolean)newSchema.isError());
        mergedSchema.setFields((List)combinedFields);
        return mergedSchema;
    }

    public static Optional<Schema> removeUncomparableFields(Schema schema) {
        return AvroUtils.removeUncomparableFields(schema, Maps.newHashMap());
    }

    private static Optional<Schema> removeUncomparableFields(Schema schema, Map<Schema, Optional<Schema>> processed) {
        switch (schema.getType()) {
            case RECORD: {
                return AvroUtils.removeUncomparableFieldsFromRecord(schema, processed);
            }
            case UNION: {
                return AvroUtils.removeUncomparableFieldsFromUnion(schema, processed);
            }
            case MAP: {
                return Optional.absent();
            }
            case ARRAY: {
                return Optional.absent();
            }
            case ENUM: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)schema);
    }

    private static Optional<Schema> removeUncomparableFieldsFromRecord(Schema record, Map<Schema, Optional<Schema>> processed) {
        Preconditions.checkArgument((record.getType() == Schema.Type.RECORD ? 1 : 0) != 0);
        Optional result = processed.get(record);
        if (null != result) {
            return result;
        }
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : record.getFields()) {
            Optional<Schema> newFieldSchema = AvroUtils.removeUncomparableFields(field.schema(), processed);
            if (!newFieldSchema.isPresent()) continue;
            fields.add(AvroCompatibilityHelper.createSchemaField((String)field.name(), (Schema)((Schema)newFieldSchema.get()), (String)field.doc(), (Object)AvroUtils.getCompatibleDefaultValue(field)));
        }
        Schema newSchema = Schema.createRecord((String)record.getName(), (String)record.getDoc(), (String)record.getNamespace(), (boolean)false);
        newSchema.setFields((List)fields);
        result = Optional.of((Object)newSchema);
        processed.put(record, (Optional<Schema>)result);
        return result;
    }

    private static Optional<Schema> removeUncomparableFieldsFromUnion(Schema union, Map<Schema, Optional<Schema>> processed) {
        Preconditions.checkArgument((union.getType() == Schema.Type.UNION ? 1 : 0) != 0);
        Optional result = processed.get(union);
        if (null != result) {
            return result;
        }
        ArrayList newUnion = Lists.newArrayList();
        for (Schema unionType : union.getTypes()) {
            Optional<Schema> newType = AvroUtils.removeUncomparableFields(unionType, processed);
            if (!newType.isPresent()) continue;
            newUnion.add(newType.get());
        }
        result = newUnion.size() != union.getTypes().size() ? Optional.absent() : Optional.of((Object)Schema.createUnion((List)newUnion));
        processed.put(union, (Optional<Schema>)result);
        return result;
    }

    public static Schema switchName(Schema schema, String newName) {
        if (schema.getName().equals(newName)) {
            return schema;
        }
        Schema newSchema = Schema.createRecord((String)newName, (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        List fields = schema.getFields();
        Iterable fieldsNew = Iterables.transform((Iterable)fields, (Function)new Function<Schema.Field, Schema.Field>(){

            public Schema.Field apply(Schema.Field input) {
                if (null == input) {
                    return null;
                }
                Schema.Field field = AvroCompatibilityHelper.createSchemaField((String)input.name(), (Schema)input.schema(), (String)input.doc(), (Object)AvroUtils.getCompatibleDefaultValue(input), (Schema.Field.Order)input.order());
                return field;
            }
        });
        newSchema.setFields((List)Lists.newArrayList((Iterable)fieldsNew));
        return newSchema;
    }

    public static Schema switchNamespace(Schema schema, Map<String, String> namespaceOverride) {
        Schema newSchema;
        String newNamespace = "";
        switch (schema.getType()) {
            case ENUM: {
                newNamespace = namespaceOverride.containsKey(schema.getNamespace()) ? namespaceOverride.get(schema.getNamespace()) : schema.getNamespace();
                newSchema = Schema.createEnum((String)schema.getName(), (String)schema.getDoc(), (String)newNamespace, (List)schema.getEnumSymbols());
                break;
            }
            case FIXED: {
                newNamespace = namespaceOverride.containsKey(schema.getNamespace()) ? namespaceOverride.get(schema.getNamespace()) : schema.getNamespace();
                newSchema = Schema.createFixed((String)schema.getName(), (String)schema.getDoc(), (String)newNamespace, (int)schema.getFixedSize());
                break;
            }
            case MAP: {
                newSchema = Schema.createMap((Schema)AvroUtils.switchNamespace(schema.getValueType(), namespaceOverride));
                break;
            }
            case RECORD: {
                newNamespace = namespaceOverride.containsKey(schema.getNamespace()) ? namespaceOverride.get(schema.getNamespace()) : schema.getNamespace();
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
                if (schema.getFields().size() > 0) {
                    for (Schema.Field oldField : schema.getFields()) {
                        Schema.Field newField = AvroCompatibilityHelper.createSchemaField((String)oldField.name(), (Schema)AvroUtils.switchNamespace(oldField.schema(), namespaceOverride), (String)oldField.doc(), (Object)AvroUtils.getCompatibleDefaultValue(oldField), (Schema.Field.Order)oldField.order());
                        AvroUtils.copyFieldProperties(oldField, newField);
                        newFields.add(newField);
                    }
                }
                newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)newNamespace, (boolean)schema.isError());
                newSchema.setFields(newFields);
                break;
            }
            case UNION: {
                ArrayList<Schema> newUnionMembers = new ArrayList<Schema>();
                if (null != schema.getTypes() && schema.getTypes().size() > 0) {
                    for (Schema oldUnionMember : schema.getTypes()) {
                        newUnionMembers.add(AvroUtils.switchNamespace(oldUnionMember, namespaceOverride));
                    }
                }
                newSchema = Schema.createUnion(newUnionMembers);
                break;
            }
            case ARRAY: {
                newSchema = Schema.createArray((Schema)AvroUtils.switchNamespace(schema.getElementType(), namespaceOverride));
                break;
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                newSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            default: {
                String exceptionMessage = String.format("Schema namespace replacement failed for \"%s\" ", schema);
                LOG.error(exceptionMessage);
                throw new AvroRuntimeException(exceptionMessage);
            }
        }
        AvroUtils.copyProperties(schema, newSchema);
        return newSchema;
    }

    private static void copyProperties(Schema oldSchema, Schema newSchema) {
        Preconditions.checkNotNull((Object)oldSchema);
        Preconditions.checkNotNull((Object)newSchema);
        AvroSchemaUtils.copySchemaProperties(oldSchema, newSchema);
    }

    public static Path serializeAsPath(GenericRecord record, boolean includeFieldNames, boolean replacePathSeparators) {
        if (record == null) {
            return new Path("");
        }
        ArrayList tokens = Lists.newArrayList();
        for (Schema.Field field : record.getSchema().getFields()) {
            String sanitizedName = HadoopUtils.sanitizePath(field.name(), "_");
            String sanitizedValue = HadoopUtils.sanitizePath(record.get(field.name()).toString(), "_");
            if (replacePathSeparators) {
                sanitizedName = sanitizedName.replaceAll("/", "_");
                sanitizedValue = sanitizedValue.replaceAll("/", "_");
            }
            if (includeFieldNames) {
                tokens.add(String.format("%s=%s", sanitizedName, sanitizedValue));
                continue;
            }
            if (Strings.isNullOrEmpty((String)sanitizedValue)) continue;
            tokens.add(sanitizedValue);
        }
        return new Path(Joiner.on((String)"/").join((Iterable)tokens));
    }

    public static String sanitizeSchemaString(String schemaString) {
        return schemaString.replace("\\\\", "\\\\\\\\").replace("\\\"", "\\\\\\\"").replace(";", "\\;").replace("'", "\\'");
    }

    public static GenericRecord slowDeserializeGenericRecord(byte[] serializedRecord, Schema schema) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedRecord, null);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericRecord)reader.read(null, (Decoder)decoder);
    }

    public static Schema decorateRecordSchema(Schema inputSchema, @Nonnull List<Schema.Field> fieldList) {
        Preconditions.checkState((boolean)inputSchema.getType().equals((Object)Schema.Type.RECORD));
        List<Schema.Field> outputFields = AvroUtils.deepCopySchemaFields(inputSchema);
        List newOutputFields = Stream.concat(outputFields.stream(), fieldList.stream()).collect(Collectors.toList());
        Schema outputSchema = Schema.createRecord((String)inputSchema.getName(), (String)inputSchema.getDoc(), (String)inputSchema.getNamespace(), (boolean)inputSchema.isError());
        outputSchema.setFields(newOutputFields);
        AvroUtils.copyProperties(inputSchema, outputSchema);
        return outputSchema;
    }

    public static GenericRecord decorateRecord(GenericRecord inputRecord, @Nonnull Map<String, Object> fieldMap, Schema outputSchema) {
        GenericData.Record outputRecord = new GenericData.Record(outputSchema);
        inputRecord.getSchema().getFields().forEach(arg_0 -> AvroUtils.lambda$decorateRecord$1((GenericRecord)outputRecord, inputRecord, arg_0));
        fieldMap.forEach((arg_0, arg_1) -> AvroUtils.lambda$decorateRecord$2((GenericRecord)outputRecord, arg_0, arg_1));
        return outputRecord;
    }

    public static GenericRecord overrideNameAndNamespace(GenericRecord input, String nameOverride, Optional<Map<String, String>> namespaceOverride) {
        GenericRecord output = input;
        Schema newSchema = AvroUtils.switchName(input.getSchema(), nameOverride);
        if (namespaceOverride.isPresent()) {
            newSchema = AvroUtils.switchNamespace(newSchema, (Map)namespaceOverride.get());
        }
        try {
            output = AvroUtils.convertRecordSchema(output, newSchema);
        }
        catch (Exception e) {
            log.error("Unable to generate generic data record", (Throwable)e);
        }
        return output;
    }

    public static Schema overrideNameAndNamespace(Schema input, String nameOverride, Optional<Map<String, String>> namespaceOverride) {
        Schema newSchema = AvroUtils.switchName(input, nameOverride);
        if (namespaceOverride.isPresent()) {
            newSchema = AvroUtils.switchNamespace(newSchema, (Map)namespaceOverride.get());
        }
        return newSchema;
    }

    public static boolean isSchemaRecursive(Schema schema, Optional<Logger> logger) {
        ArrayList<SchemaEntry> recursiveFields = new ArrayList<SchemaEntry>();
        AvroUtils.dropRecursive(new SchemaEntry(null, schema), Collections.EMPTY_LIST, recursiveFields);
        if (recursiveFields.isEmpty()) {
            return false;
        }
        if (logger.isPresent()) {
            ((Logger)logger.get()).info("Found recursive fields [{}] in schema {}", (Object)recursiveFields.stream().map(f -> f.fieldName).collect(Collectors.joining(",")), (Object)schema.getFullName());
        }
        return true;
    }

    public static Pair<Schema, List<SchemaEntry>> dropRecursiveFields(Schema schema) {
        ArrayList<SchemaEntry> recursiveFields = new ArrayList<SchemaEntry>();
        return new Pair((Object)AvroUtils.dropRecursive(new SchemaEntry(null, schema), Collections.EMPTY_LIST, recursiveFields), recursiveFields);
    }

    private static Schema dropRecursive(SchemaEntry schemaEntry, List<SchemaEntry> parents, List<SchemaEntry> fieldsWithRecursion) {
        Schema schema = schemaEntry.schema;
        switch (schema.getType()) {
            case UNION: {
                List unionTypes = schema.getTypes();
                ArrayList<Schema> copiedUnionTypes = new ArrayList<Schema>();
                for (Schema unionSchema : unionTypes) {
                    SchemaEntry unionSchemaEntry = new SchemaEntry(schemaEntry.fieldName, unionSchema);
                    copiedUnionTypes.add(AvroUtils.dropRecursive(unionSchemaEntry, parents, fieldsWithRecursion));
                }
                if (copiedUnionTypes.stream().anyMatch(x -> x == null)) {
                    return null;
                }
                Schema copySchema = Schema.createUnion(copiedUnionTypes);
                AvroUtils.copyProperties(schema, copySchema);
                return copySchema;
            }
            case RECORD: {
                if (parents.stream().anyMatch(parent -> parent.fullyQualifiedType().equals(schemaEntry.fullyQualifiedType()))) {
                    fieldsWithRecursion.add(schemaEntry);
                    return null;
                }
                ArrayList<SchemaEntry> newParents = new ArrayList<SchemaEntry>(parents);
                newParents.add(schemaEntry);
                ArrayList<Schema.Field> copiedSchemaFields = new ArrayList<Schema.Field>();
                Iterator copySchema = schema.getFields().iterator();
                while (copySchema.hasNext()) {
                    Schema.Field field;
                    String fieldName = schemaEntry.fieldName != null ? schemaEntry.fieldName + FIELD_LOCATION_DELIMITER + field.name() : field.name();
                    SchemaEntry fieldSchemaEntry = new SchemaEntry(fieldName, (field = (Schema.Field)copySchema.next()).schema());
                    Schema copiedFieldSchema = AvroUtils.dropRecursive(fieldSchemaEntry, newParents, fieldsWithRecursion);
                    if (copiedFieldSchema == null) continue;
                    Schema.Field copiedField = AvroCompatibilityHelper.createSchemaField((String)field.name(), (Schema)copiedFieldSchema, (String)field.doc(), (Object)AvroUtils.getCompatibleDefaultValue(field), (Schema.Field.Order)field.order());
                    AvroUtils.copyFieldProperties(field, copiedField);
                    copiedSchemaFields.add(copiedField);
                }
                if (copiedSchemaFields.size() > 0) {
                    Schema copiedRecord = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
                    copiedRecord.setFields(copiedSchemaFields);
                    AvroUtils.copyProperties(schema, copiedRecord);
                    return copiedRecord;
                }
                return null;
            }
            case ARRAY: {
                Schema itemSchema = schema.getElementType();
                SchemaEntry itemSchemaEntry = new SchemaEntry(schemaEntry.fieldName, itemSchema);
                Schema copiedItemSchema = AvroUtils.dropRecursive(itemSchemaEntry, parents, fieldsWithRecursion);
                if (copiedItemSchema == null) {
                    return null;
                }
                Schema copiedArraySchema = Schema.createArray((Schema)copiedItemSchema);
                AvroUtils.copyProperties(schema, copiedArraySchema);
                return copiedArraySchema;
            }
            case MAP: {
                Schema valueSchema = schema.getValueType();
                SchemaEntry valueSchemaEntry = new SchemaEntry(schemaEntry.fieldName, valueSchema);
                Schema copiedValueSchema = AvroUtils.dropRecursive(valueSchemaEntry, parents, fieldsWithRecursion);
                if (copiedValueSchema == null) {
                    return null;
                }
                Schema copiedMapSchema = Schema.createMap((Schema)copiedValueSchema);
                AvroUtils.copyProperties(schema, copiedMapSchema);
                return copiedMapSchema;
            }
        }
        return schema;
    }

    private static void copyFieldProperties(Schema.Field sourceField, Schema.Field copiedField) {
        AvroSchemaUtils.copyFieldProperties(sourceField, copiedField);
    }

    @Nullable
    public static Object getCompatibleDefaultValue(Schema.Field field) {
        return AvroCompatibilityHelper.fieldHasDefault((Schema.Field)field) ? AvroCompatibilityHelper.getGenericDefaultValue((Schema.Field)field) : null;
    }

    private static /* synthetic */ void lambda$decorateRecord$2(GenericRecord outputRecord, String key, Object value) {
        outputRecord.put(key, value);
    }

    private static /* synthetic */ void lambda$decorateRecord$1(GenericRecord outputRecord, GenericRecord inputRecord, Schema.Field f) {
        outputRecord.put(f.name(), inputRecord.get(f.name()));
    }

    public static class SchemaEntry {
        final String fieldName;
        final Schema schema;

        String fullyQualifiedType() {
            return this.schema.getFullName();
        }

        SchemaEntry(String fieldName, Schema schema) {
            this.fieldName = fieldName;
            this.schema = schema;
        }

        public static SchemaEntryBuilder builder() {
            return new SchemaEntryBuilder();
        }

        public String toString() {
            return "AvroUtils.SchemaEntry(fieldName=" + this.getFieldName() + ", schema=" + this.schema + ")";
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public static class SchemaEntryBuilder {
            private String fieldName;
            private Schema schema;

            SchemaEntryBuilder() {
            }

            public SchemaEntryBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public SchemaEntryBuilder schema(Schema schema) {
                this.schema = schema;
                return this;
            }

            public SchemaEntry build() {
                return new SchemaEntry(this.fieldName, this.schema);
            }

            public String toString() {
                return "AvroUtils.SchemaEntry.SchemaEntryBuilder(fieldName=" + this.fieldName + ", schema=" + this.schema + ")";
            }
        }
    }

    public static class AvroPathFilter
    implements PathFilter {
        public boolean accept(Path path) {
            return path.getName().endsWith(AvroUtils.AVRO_SUFFIX);
        }
    }
}

