/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import java.util.List;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaUtils {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaUtils.class);

    private AvroSchemaUtils() {
    }

    public static Integer getValueAsInteger(Schema schema, String prop) {
        String value = AvroCompatibilityHelper.getSchemaPropAsJsonString((Schema)schema, (String)prop, (boolean)false, (boolean)false);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            log.error("Exception while converting to integer ", ex.getCause());
            throw new IllegalArgumentException(ex);
        }
    }

    public static void copyFieldProperties(Schema.Field fromField, Schema.Field toField) {
        List allPropNames = AvroCompatibilityHelper.getAllPropNames((Schema.Field)fromField);
        if (null != allPropNames) {
            for (String propName : allPropNames) {
                String propValue = AvroCompatibilityHelper.getFieldPropAsJsonString((Schema.Field)fromField, (String)propName, (boolean)true, (boolean)false);
                AvroCompatibilityHelper.setFieldPropFromJsonString((Schema.Field)toField, (String)propName, (String)propValue, (boolean)false);
            }
        }
    }

    public static void copySchemaProperties(Schema fromSchema, Schema toSchema) {
        List allPropNames = AvroCompatibilityHelper.getAllPropNames((Schema)fromSchema);
        if (null != allPropNames) {
            for (String propName : allPropNames) {
                String propValue = AvroCompatibilityHelper.getSchemaPropAsJsonString((Schema)fromSchema, (String)propName, (boolean)true, (boolean)false);
                AvroCompatibilityHelper.setSchemaPropFromJsonString((Schema)toSchema, (String)propName, (String)propValue, (boolean)false);
            }
        }
    }
}

