/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.util.AvroSchemaUtils;
import org.apache.gobblin.util.AvroUtils;
import org.apache.log4j.Logger;

public class AvroFlattener {
    private static final Logger LOG = Logger.getLogger(AvroFlattener.class);
    private static final String FLATTENED_NAME_JOINER = "__";
    private static final String FLATTENED_SOURCE_JOINER = ".";
    public static final String FLATTENED_SOURCE_KEY = "flatten_source";
    private String flattenedNameJoiner;
    private String flattenedSourceJoiner;

    public Schema flatten(Schema schema, boolean flattenComplexTypes) {
        Preconditions.checkNotNull((Object)schema);
        this.flattenedNameJoiner = FLATTENED_NAME_JOINER;
        this.flattenedSourceJoiner = FLATTENED_SOURCE_JOINER;
        Schema flattenedSchema = this.flatten(schema, false, flattenComplexTypes);
        LOG.debug((Object)("Original Schema : " + schema));
        LOG.debug((Object)("Flattened Schema: " + flattenedSchema));
        return flattenedSchema;
    }

    private Schema flatten(Schema schema, boolean shouldPopulateLineage, boolean flattenComplexTypes) {
        Schema flattenedSchema;
        switch (schema.getType()) {
            case ARRAY: {
                if (flattenComplexTypes) {
                    flattenedSchema = Schema.createArray((Schema)this.flatten(schema.getElementType(), false));
                    break;
                }
                flattenedSchema = Schema.createArray((Schema)schema.getElementType());
                break;
            }
            case BOOLEAN: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case BYTES: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case DOUBLE: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case ENUM: {
                flattenedSchema = Schema.createEnum((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (List)schema.getEnumSymbols());
                break;
            }
            case FIXED: {
                flattenedSchema = Schema.createFixed((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (int)schema.getFixedSize());
                break;
            }
            case FLOAT: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case INT: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case LONG: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case MAP: {
                if (flattenComplexTypes) {
                    flattenedSchema = Schema.createMap((Schema)this.flatten(schema.getValueType(), false));
                    break;
                }
                flattenedSchema = Schema.createMap((Schema)schema.getValueType());
                break;
            }
            case NULL: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case RECORD: {
                flattenedSchema = this.flattenRecord(schema, shouldPopulateLineage, flattenComplexTypes);
                break;
            }
            case STRING: {
                flattenedSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            case UNION: {
                flattenedSchema = this.flattenUnion(schema, shouldPopulateLineage, flattenComplexTypes);
                break;
            }
            default: {
                String exceptionMessage = String.format("Schema flattening failed for \"%s\" ", schema);
                LOG.error((Object)exceptionMessage);
                throw new AvroRuntimeException(exceptionMessage);
            }
        }
        AvroFlattener.copyProperties(schema, flattenedSchema);
        return flattenedSchema;
    }

    private Schema flattenRecord(Schema schema, boolean shouldPopulateLineage, boolean flattenComplexTypes) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)schema.getType()));
        ArrayList<Schema.Field> flattenedFields = new ArrayList<Schema.Field>();
        if (schema.getFields().size() > 0) {
            for (Schema.Field oldField : schema.getFields()) {
                List<Schema.Field> newFields = this.flattenField(oldField, (ImmutableList<String>)ImmutableList.of(), shouldPopulateLineage, flattenComplexTypes, (Optional<Schema>)Optional.absent());
                if (null == newFields || newFields.size() <= 0) continue;
                flattenedFields.addAll(newFields);
            }
        }
        Schema flattenedSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        flattenedSchema.setFields(flattenedFields);
        return flattenedSchema;
    }

    private Schema flattenUnion(Schema schema, boolean shouldPopulateLineage, boolean flattenComplexTypes) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((boolean)Schema.Type.UNION.equals((Object)schema.getType()));
        ArrayList<Schema> flattenedUnionMembers = new ArrayList<Schema>();
        if (null != schema.getTypes() && schema.getTypes().size() > 0) {
            for (Schema oldUnionMember : schema.getTypes()) {
                if (flattenComplexTypes) {
                    flattenedUnionMembers.add(this.flatten(oldUnionMember, shouldPopulateLineage, flattenComplexTypes));
                    continue;
                }
                flattenedUnionMembers.add(oldUnionMember);
            }
        }
        Schema flattenedSchema = Schema.createUnion(flattenedUnionMembers);
        return flattenedSchema;
    }

    private List<Schema.Field> flattenField(Schema.Field f, ImmutableList<String> parentLineage, boolean shouldPopulateLineage, boolean flattenComplexTypes, Optional<Schema> shouldWrapInOption) {
        Preconditions.checkNotNull((Object)f);
        Preconditions.checkNotNull((Object)f.schema());
        Preconditions.checkNotNull((Object)f.name());
        ArrayList<Schema.Field> flattenedFields = new ArrayList<Schema.Field>();
        ImmutableList lineage = ImmutableList.builder().addAll((Iterator)parentLineage.iterator()).add((Object)f.name()).build();
        if (Schema.Type.RECORD.equals((Object)f.schema().getType())) {
            if (null != f.schema().getFields() && f.schema().getFields().size() > 0) {
                for (Schema.Field field : f.schema().getFields()) {
                    flattenedFields.addAll(this.flattenField(field, (ImmutableList<String>)lineage, true, flattenComplexTypes, (Optional<Schema>)Optional.absent()));
                }
            }
        } else {
            Optional<Schema> optionalRecord = AvroFlattener.isOfOptionType(f.schema());
            if (optionalRecord.isPresent()) {
                Schema record = (Schema)optionalRecord.get();
                if (record.getFields().size() > 0) {
                    for (Schema.Field field : record.getFields()) {
                        flattenedFields.addAll(this.flattenField(field, (ImmutableList<String>)lineage, true, flattenComplexTypes, (Optional<Schema>)Optional.of((Object)f.schema())));
                    }
                }
            } else {
                String flattenName = f.name();
                String flattenSource = "";
                if (shouldPopulateLineage) {
                    flattenName = StringUtils.join((Iterable)lineage, (String)this.flattenedNameJoiner);
                    flattenSource = StringUtils.join((Iterable)lineage, (String)this.flattenedSourceJoiner);
                }
                Schema flattenedFieldSchema = this.flatten(f.schema(), shouldPopulateLineage, flattenComplexTypes);
                if (shouldWrapInOption.isPresent()) {
                    boolean isNullFirstMember = Schema.Type.NULL.equals((Object)((Schema)((Schema)shouldWrapInOption.get()).getTypes().get(0)).getType());
                    if (Schema.Type.UNION.equals((Object)flattenedFieldSchema.getType())) {
                        ArrayList<Schema> newUnionMembers = new ArrayList<Schema>();
                        if (isNullFirstMember) {
                            newUnionMembers.add(Schema.create((Schema.Type)Schema.Type.NULL));
                        }
                        for (Schema type : flattenedFieldSchema.getTypes()) {
                            if (Schema.Type.NULL.equals((Object)type.getType())) continue;
                            newUnionMembers.add(type);
                        }
                        if (!isNullFirstMember) {
                            newUnionMembers.add(Schema.create((Schema.Type)Schema.Type.NULL));
                        }
                        flattenedFieldSchema = Schema.createUnion(newUnionMembers);
                    } else {
                        if (f.hasDefaultValue() && f.defaultVal() != null) {
                            isNullFirstMember = false;
                        }
                        flattenedFieldSchema = isNullFirstMember ? Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), flattenedFieldSchema)) : Schema.createUnion(Arrays.asList(flattenedFieldSchema, Schema.create((Schema.Type)Schema.Type.NULL)));
                    }
                }
                Schema.Field field = AvroCompatibilityHelper.createSchemaField((String)flattenName, (Schema)flattenedFieldSchema, (String)f.doc(), (Object)AvroUtils.getCompatibleDefaultValue(f), (Schema.Field.Order)f.order());
                if (StringUtils.isNotBlank((CharSequence)flattenSource)) {
                    field.addProp(FLATTENED_SOURCE_KEY, flattenSource);
                }
                AvroSchemaUtils.copyFieldProperties(f, field);
                flattenedFields.add(field);
            }
        }
        return flattenedFields;
    }

    private static Optional<Schema> isOfOptionType(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (!Schema.Type.UNION.equals((Object)schema.getType())) {
            return Optional.absent();
        }
        List types = schema.getTypes();
        if (null != types && types.size() == 2) {
            Schema first = (Schema)types.get(0);
            Schema second = (Schema)types.get(1);
            if (Schema.Type.NULL.equals((Object)first.getType()) && Schema.Type.RECORD.equals((Object)second.getType())) {
                return Optional.of((Object)second);
            }
            if (Schema.Type.RECORD.equals((Object)first.getType()) && Schema.Type.NULL.equals((Object)second.getType())) {
                return Optional.of((Object)first);
            }
        }
        return Optional.absent();
    }

    private static void copyProperties(Schema oldSchema, Schema newSchema) {
        Preconditions.checkNotNull((Object)oldSchema);
        Preconditions.checkNotNull((Object)newSchema);
        AvroSchemaUtils.copySchemaProperties(oldSchema, newSchema);
    }
}

