/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.time;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TimeIterator
implements Iterator {
    private ZonedDateTime startTime;
    private ZonedDateTime endTime;
    private Granularity granularity;
    private boolean reverse;

    public TimeIterator(ZonedDateTime startTime, ZonedDateTime endTime, Granularity granularity) {
        this(startTime, endTime, granularity, false);
    }

    public TimeIterator(ZonedDateTime startTime, ZonedDateTime endTime, Granularity granularity, boolean reverse) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.granularity = granularity;
        this.reverse = reverse;
    }

    @Override
    public boolean hasNext() {
        return this.reverse ? !this.endTime.isAfter(this.startTime) : !this.startTime.isAfter(this.endTime);
    }

    public ZonedDateTime next() {
        if (!this.reverse && this.startTime.isAfter(this.endTime) || this.reverse && this.endTime.isAfter(this.startTime)) {
            throw new NoSuchElementException();
        }
        ZonedDateTime dateTime = this.startTime;
        this.startTime = this.reverse ? TimeIterator.dec(this.startTime, this.granularity, 1L) : TimeIterator.inc(this.startTime, this.granularity, 1L);
        return dateTime;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static ZonedDateTime inc(ZonedDateTime time, Granularity granularity, long units) {
        switch (granularity) {
            case MINUTE: {
                return time.plusMinutes(units);
            }
            case HOUR: {
                return time.plusHours(units);
            }
            case DAY: {
                return time.plusDays(units);
            }
            case MONTH: {
                return time.plusMonths(units);
            }
        }
        throw new RuntimeException("Unsupported granularity: " + (Object)((Object)granularity));
    }

    public static ZonedDateTime dec(ZonedDateTime time, Granularity granularity, long units) {
        switch (granularity) {
            case MINUTE: {
                return time.minusMinutes(units);
            }
            case HOUR: {
                return time.minusHours(units);
            }
            case DAY: {
                return time.minusDays(units);
            }
            case MONTH: {
                return time.minusMonths(units);
            }
        }
        throw new RuntimeException("Unsupported granularity: " + (Object)((Object)granularity));
    }

    public static long durationBetween(ZonedDateTime d1, ZonedDateTime d2, Granularity granularity) {
        switch (granularity) {
            case HOUR: {
                return Duration.between(d1, d2).toHours();
            }
            case MINUTE: {
                return Duration.between(d1, d2).toMinutes();
            }
            case DAY: {
                return Duration.between(d1, d2).toDays();
            }
            case MONTH: {
                return ChronoUnit.MONTHS.between(d1, d2);
            }
        }
        throw new RuntimeException("Unsupported granularity: " + (Object)((Object)granularity));
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public static enum Granularity {
        MINUTE,
        HOUR,
        DAY,
        MONTH;

    }
}

