/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.util.concurrent.Service;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.gobblin.broker.ScopeWrapper;
import org.apache.gobblin.broker.iface.ScopeType;
import org.slf4j.Logger;

public class SharedResourcesBrokerUtils {
    public static <S extends ScopeType<S>> boolean isScopeTypeAncestor(S scopeType, S possibleAncestor) {
        LinkedList<S> ancestors = new LinkedList<S>();
        ancestors.add(scopeType);
        while (!ancestors.isEmpty()) {
            if (((ScopeType)ancestors.peek()).equals(possibleAncestor)) {
                return true;
            }
            Collection parentScopes = ((ScopeType)ancestors.poll()).parentScopes();
            if (parentScopes == null) continue;
            ancestors.addAll(parentScopes);
        }
        return false;
    }

    static <S extends ScopeType<S>> boolean isScopeAncestor(ScopeWrapper<S> scope, ScopeWrapper<S> possibleAncestor) {
        LinkedList ancestors = new LinkedList();
        ancestors.add(scope);
        while (!ancestors.isEmpty()) {
            if (((ScopeWrapper)ancestors.peek()).equals(possibleAncestor)) {
                return true;
            }
            ancestors.addAll(((ScopeWrapper)ancestors.poll()).getParentScopes());
        }
        return false;
    }

    public static void shutdownObject(Object obj, Logger log) {
        if (obj instanceof Service) {
            ((Service)obj).stopAsync();
        } else if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException ioe) {
                log.error("Failed to close {}.", obj);
            }
        }
    }
}

