/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.test;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.WorkUnit;

public class FastSequentialSource
implements Source<String, Long> {
    public static final String NUM_WORK_UNITS = FastSequentialSource.class.getSimpleName() + ".numWorkUnits";
    public static final String MAX_RECORDS_PER_WORK_UNIT = FastSequentialSource.class.getSimpleName() + ".maxRecordsPerWorkUnit";
    public static final String MAX_SECONDS_PER_WORK_UNIT = FastSequentialSource.class.getSimpleName() + ".maxSecondsPerWorkUnit";

    public List<WorkUnit> getWorkunits(SourceState state) {
        ArrayList workUnits = Lists.newArrayList();
        for (int i = 0; i < state.getPropAsInt(NUM_WORK_UNITS, 1); ++i) {
            workUnits.add(new WorkUnit());
        }
        return workUnits;
    }

    public Extractor<String, Long> getExtractor(WorkUnitState state) throws IOException {
        return new FastSequentialExtractor(state.getPropAsLong(MAX_RECORDS_PER_WORK_UNIT), state.getPropAsLong(MAX_SECONDS_PER_WORK_UNIT));
    }

    public void shutdown(SourceState state) {
    }

    public static class FastSequentialExtractor
    implements Extractor<String, Long> {
        private final long maxRecords;
        private final long maxSeconds;
        private volatile long endTime;
        private volatile long recordNumber;

        public String getSchema() throws IOException {
            return "schema";
        }

        public Long readRecord(@Deprecated Long reuse) throws DataRecordException, IOException {
            if (this.endTime == 0L) {
                this.endTime = System.currentTimeMillis() + this.maxSeconds * 1000L;
            }
            if (System.currentTimeMillis() > this.endTime || this.recordNumber >= this.maxRecords) {
                return null;
            }
            return this.recordNumber++;
        }

        public long getExpectedRecordCount() {
            return this.maxRecords;
        }

        public long getHighWatermark() {
            return 0L;
        }

        public void close() throws IOException {
        }

        @ConstructorProperties(value={"maxRecords", "maxSeconds"})
        public FastSequentialExtractor(long maxRecords, long maxSeconds) {
            this.maxRecords = maxRecords;
            this.maxSeconds = maxSeconds;
        }
    }
}

