/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.retry;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.exception.NonTransientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryerFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryerFactory.class);
    public static final String RETRY_MULTIPLIER = "multiplier";
    public static final String RETRY_INTERVAL_MS = "interval_ms";
    public static final String RETRY_TIME_OUT_MS = "time_out_ms";
    public static final String RETRY_TYPE = "retry_type";
    private static final Predicate<Throwable> RETRY_EXCEPTION_PREDICATE = new Predicate<Throwable>(){

        public boolean apply(Throwable t) {
            return !(t instanceof NonTransientException);
        }
    };
    private static final Config DEFAULTS;

    public static <T> Retryer<T> newInstance(Config config) {
        config = config.withFallback((ConfigMergeable)DEFAULTS);
        RetryType type = RetryType.valueOf(config.getString(RETRY_TYPE).toUpperCase());
        switch (type) {
            case EXPONENTIAL: {
                return RetryerFactory.newExponentialRetryer(config);
            }
            case FIXED: {
                return RetryerFactory.newFixedRetryer(config);
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + " is not supported");
    }

    private static <T> Retryer<T> newFixedRetryer(Config config) {
        return RetryerBuilder.newBuilder().retryIfException(RETRY_EXCEPTION_PREDICATE).withWaitStrategy(WaitStrategies.fixedWait((long)config.getLong(RETRY_INTERVAL_MS), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)config.getLong(RETRY_TIME_OUT_MS), (TimeUnit)TimeUnit.MILLISECONDS)).build();
    }

    private static <T> Retryer<T> newExponentialRetryer(Config config) {
        return RetryerBuilder.newBuilder().retryIfException(RETRY_EXCEPTION_PREDICATE).withWaitStrategy(WaitStrategies.exponentialWait((long)config.getLong(RETRY_MULTIPLIER), (long)config.getLong(RETRY_INTERVAL_MS), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)config.getLong(RETRY_TIME_OUT_MS), (TimeUnit)TimeUnit.MILLISECONDS)).build();
    }

    static {
        ImmutableMap configMap = ImmutableMap.builder().put((Object)RETRY_TIME_OUT_MS, (Object)TimeUnit.MINUTES.toMillis(5L)).put((Object)RETRY_INTERVAL_MS, (Object)TimeUnit.SECONDS.toMillis(30L)).put((Object)RETRY_MULTIPLIER, (Object)2L).put((Object)RETRY_TYPE, (Object)RetryType.EXPONENTIAL.name()).build();
        DEFAULTS = ConfigFactory.parseMap((Map)configMap);
    }

    public static enum RetryType {
        EXPONENTIAL,
        FIXED;

    }
}

