/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.filesystem.PathAlterationListener;
import org.apache.gobblin.util.filesystem.PathAlterationObserver;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathAlterationObserverScheduler
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathAlterationObserverScheduler.class);
    private final long interval;
    private volatile boolean running = false;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ExecutorsUtils.newDaemonThreadFactory((Optional<Logger>)Optional.of((Object)LOGGER), (Optional<String>)Optional.of((Object)"newDaemonThreadFactory")));
    private ScheduledFuture<?> executionResult;
    private final List<PathAlterationObserver> observers = new CopyOnWriteArrayList<PathAlterationObserver>();
    private int initialDelay = 0;

    public PathAlterationObserverScheduler() {
        this(3000L);
    }

    public PathAlterationObserverScheduler(long interval) {
        this.interval = interval;
    }

    public void addObserver(PathAlterationObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(PathAlterationObserver observer) {
        if (observer != null) {
            while (this.observers.remove(observer)) {
            }
        }
    }

    public Iterable<PathAlterationObserver> getObservers() {
        return this.observers;
    }

    public synchronized void start() throws IOException {
        if (this.running) {
            throw new IllegalStateException("Monitor is already running");
        }
        for (PathAlterationObserver observer : this.observers) {
            observer.initialize();
        }
        if (this.interval > 0L) {
            this.running = true;
            this.executionResult = this.executor.scheduleWithFixedDelay(this, this.initialDelay, this.interval, TimeUnit.MILLISECONDS);
        } else {
            LOGGER.info("Not starting due to non-positive scheduling interval:" + this.interval);
        }
    }

    public synchronized void stop() throws IOException, InterruptedException {
        this.stop(this.interval);
    }

    public synchronized void stop(long stopInterval) throws IOException, InterruptedException {
        if (!this.running) {
            LOGGER.warn("Already stopped");
            return;
        }
        this.running = false;
        for (PathAlterationObserver observer : this.observers) {
            observer.destroy();
        }
        this.executionResult.cancel(true);
        this.executor.shutdown();
        if (!this.executor.awaitTermination(stopInterval, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("Did not shutdown in the timeout period");
        }
    }

    @Override
    public void run() {
        if (!this.running) {
            return;
        }
        for (PathAlterationObserver observer : this.observers) {
            try {
                observer.checkAndNotify();
            }
            catch (IOException ioe) {
                LOGGER.error("Path alteration detector error.", (Throwable)ioe);
            }
        }
    }

    public void addPathAlterationObserver(PathAlterationListener listener, Optional<PathAlterationObserver> observerOptional, Path rootDirPath) throws IOException {
        PathAlterationObserver observer = (PathAlterationObserver)observerOptional.or((Object)new PathAlterationObserver(rootDirPath));
        observer.addListener(listener);
        this.addObserver(observer);
    }
}

