/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.google.common.base.Optional;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileStatusEntry
extends FileStatus {
    static final FileStatusEntry[] EMPTY_ENTRIES = new FileStatusEntry[0];
    private final FileStatusEntry parent;
    private FileStatusEntry[] children;
    private boolean exists;
    private final FileSystem fs;
    public Optional<FileStatus> _fileStatus;

    public FileStatusEntry(Path path) throws IOException {
        this(null, path, path.getFileSystem(new Configuration()));
    }

    private FileStatusEntry(FileStatusEntry parent, Path path, FileSystem fs) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path is missing");
        }
        this.parent = parent;
        this.fs = fs;
        this._fileStatus = Optional.fromNullable((Object)this.fs.getFileStatus(path));
    }

    public boolean refresh(Path path) throws IOException {
        if (this._fileStatus.isPresent()) {
            Optional<FileStatus> oldStatus = this._fileStatus;
            try {
                this._fileStatus = Optional.of((Object)this.fs.getFileStatus(path));
                this.exists = this._fileStatus.isPresent();
                return oldStatus.isPresent() != this._fileStatus.isPresent() || ((FileStatus)oldStatus.get()).getModificationTime() != ((FileStatus)this._fileStatus.get()).getModificationTime() || ((FileStatus)oldStatus.get()).isDirectory() != ((FileStatus)this._fileStatus.get()).isDirectory() || ((FileStatus)oldStatus.get()).getLen() != ((FileStatus)this._fileStatus.get()).getLen();
            }
            catch (FileNotFoundException e) {
                this._fileStatus = Optional.absent();
                this.exists = false;
                return true;
            }
        }
        if (path.getFileSystem(new Configuration()).exists(path)) {
            this._fileStatus = Optional.of((Object)this.fs.getFileStatus(path));
            return true;
        }
        return false;
    }

    public FileStatusEntry newChildInstance(Path path) throws IOException {
        return new FileStatusEntry(this, path, this.fs);
    }

    public FileStatusEntry getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public FileStatusEntry[] getChildren() {
        return this.children != null ? this.children : EMPTY_ENTRIES;
    }

    public void setChildren(FileStatusEntry[] children) {
        this.children = children;
    }

    public boolean isExists() {
        return this.exists;
    }

    public Path getPath() {
        return ((FileStatus)this._fileStatus.get()).getPath();
    }

    public boolean isDirectory() {
        return ((FileStatus)this._fileStatus.get()).isDirectory();
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FileStatusEntry other = (FileStatusEntry)((Object)o);
        return ((FileStatus)this._fileStatus.get()).equals(other._fileStatus.get());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

