/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Logger logger;

    public LoggingUncaughtExceptionHandler(Optional<Logger> logger) {
        this.logger = logger.isPresent() ? (Logger)logger.get() : LoggerFactory.getLogger(LoggingUncaughtExceptionHandler.class);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logger.error(String.format("Thread %s threw an uncaught exception: %s", t, e), e);
    }
}

