/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.broker.DefaultBrokerCache;
import org.apache.gobblin.broker.ScopeWrapper;
import org.apache.gobblin.broker.SharedResourcesBrokerImpl;
import org.apache.gobblin.broker.SimpleScopeType;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;

public class SharedResourcesBrokerFactory {
    public static final String LOAD_HADOOP_CONFIGURATION = "gobblin.broker.loadHadoopConfiguration";
    public static final String BROKER_CONF_FILE_KEY = "gobblin.broker.configuration";
    public static final String DEFAULT_BROKER_CONF_FILE = "gobblinBroker.conf";
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Config BROKER_NAMESPACES_FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"gobblin.brokerNamespaces", (Object)"").build());
    private static InheritableThreadLocal<SharedResourcesBroker<?>> threadLocalBroker = new ThreadLocalBroker();
    private static SharedResourcesBroker<SimpleScopeType> SINGLETON;

    public static <S extends ScopeType<S>> SharedResourcesBrokerImpl<S> createDefaultTopLevelBroker(Config config, ScopeInstance<S> globalScope) {
        if (!globalScope.getType().equals(globalScope.getType().rootScope())) {
            throw new IllegalArgumentException(String.format("The top level broker must be created at the root scope type. %s is not a root scope type.", globalScope.getType()));
        }
        ScopeWrapper<ScopeType> scopeWrapper = new ScopeWrapper<ScopeType>(globalScope.getType(), globalScope, Lists.newArrayList());
        return new SharedResourcesBrokerImpl<ScopeType>(new DefaultBrokerCache(), scopeWrapper, Lists.newArrayList((Object[])new SharedResourcesBrokerImpl.ScopedConfig[]{new SharedResourcesBrokerImpl.ScopedConfig<ScopeType>(globalScope.getType(), SharedResourcesBrokerFactory.getBrokerConfig(SharedResourcesBrokerFactory.addSystemConfigurationToConfig(config)))}), (Map<ScopeType, ScopeWrapper<ScopeType>>)ImmutableMap.of((Object)globalScope.getType(), scopeWrapper));
    }

    @VisibleForTesting
    static Config getBrokerConfig(Config srcConfig) {
        Config allSrcConfig = srcConfig.withFallback((ConfigMergeable)BROKER_NAMESPACES_FALLBACK);
        String namespaces = allSrcConfig.getString("gobblin.brokerNamespaces");
        Config brokerConfig = ConfigUtils.getConfigOrEmpty(allSrcConfig, "gobblin.broker");
        for (String namespace : LIST_SPLITTER.splitToList((CharSequence)namespaces)) {
            brokerConfig = brokerConfig.withFallback((ConfigMergeable)ConfigUtils.getConfigOrEmpty(allSrcConfig, namespace));
        }
        return brokerConfig;
    }

    public static SharedResourcesBroker<?> getImplicitBroker() {
        SharedResourcesBroker threadLocal = (SharedResourcesBroker)threadLocalBroker.get();
        return threadLocal == null ? SharedResourcesBrokerFactory.getSingleton() : threadLocal;
    }

    public static void registerImplicitBroker(SharedResourcesBroker<?> broker) {
        threadLocalBroker.set(broker);
    }

    private static synchronized SharedResourcesBroker<SimpleScopeType> getSingleton() {
        if (SINGLETON == null) {
            SINGLETON = SharedResourcesBrokerFactory.createDefaultTopLevelBroker(ConfigFactory.empty(), SimpleScopeType.GLOBAL.defaultScopeInstance());
        }
        return SINGLETON;
    }

    private static Config addSystemConfigurationToConfig(Config config) {
        Config resourceConfig;
        HashMap confMap = Maps.newHashMap();
        SharedResourcesBrokerFactory.addBrokerKeys(confMap, System.getenv().entrySet());
        SharedResourcesBrokerFactory.addBrokerKeys(confMap, System.getProperties().entrySet());
        Config systemConfig = ConfigFactory.parseMap((Map)confMap);
        Config tmpConfig = config.withFallback((ConfigMergeable)systemConfig);
        String brokerConfPath = DEFAULT_BROKER_CONF_FILE;
        if (tmpConfig.hasPath(BROKER_CONF_FILE_KEY)) {
            brokerConfPath = tmpConfig.getString(BROKER_CONF_FILE_KEY);
        }
        if (ConfigUtils.getBoolean(config = config.withFallback((ConfigMergeable)(resourceConfig = ConfigFactory.parseResources(SharedResourcesBrokerFactory.class, (String)brokerConfPath))).withFallback((ConfigMergeable)systemConfig), LOAD_HADOOP_CONFIGURATION, true)) {
            HashMap hadoopConfMap = Maps.newHashMap();
            Configuration hadoopConf = new Configuration();
            hadoopConf.addResource("gobblin-site.xml");
            SharedResourcesBrokerFactory.addBrokerKeys(hadoopConfMap, hadoopConf);
            config = config.withFallback((ConfigMergeable)ConfigFactory.parseMap((Map)hadoopConfMap));
        }
        return config;
    }

    public static <S, T> void addBrokerKeys(Map<String, String> configMap, Iterable<Map.Entry<S, T>> entries) {
        for (Map.Entry<S, T> entry : entries) {
            S key = entry.getKey();
            if (!(key instanceof String) || !((String)key).startsWith("gobblin.broker")) continue;
            configMap.put((String)key, entry.getValue().toString());
        }
    }

    private static class ThreadLocalBroker
    extends InheritableThreadLocal<SharedResourcesBroker<?>> {
        private ThreadLocalBroker() {
        }
    }
}

