/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.Striped;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.gobblin.broker.ResourceCoordinate;
import org.apache.gobblin.broker.ResourceEntry;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.ScopeWrapper;
import org.apache.gobblin.broker.SharedResourcesBrokerImpl;
import org.apache.gobblin.broker.SharedResourcesBrokerUtils;
import org.apache.gobblin.broker.iface.NoSuchScopeException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultBrokerCache<S extends ScopeType<S>> {
    private static final Logger log = LoggerFactory.getLogger(DefaultBrokerCache.class);
    private final Cache<RawJobBrokerKey, Object> sharedResourceCache = CacheBuilder.newBuilder().build();
    private final Cache<RawJobBrokerKey, ScopeWrapper<S>> autoScopeCache = CacheBuilder.newBuilder().build();
    private final Striped<Lock> invalidationLock = Striped.lazyWeakLock((int)20);

    <T, K extends SharedResourceKey> T getAutoScoped(final SharedResourceFactory<T, K, S> factory, final K key, final SharedResourcesBrokerImpl<S> broker) throws ExecutionException {
        RawJobBrokerKey autoscopeCacheKey = new RawJobBrokerKey(broker.getWrappedSelfScope(), factory.getName(), key);
        ScopeWrapper selectedScope = (ScopeWrapper)this.autoScopeCache.get((Object)autoscopeCacheKey, new Callable<ScopeWrapper<S>>(){

            @Override
            public ScopeWrapper<S> call() throws Exception {
                return broker.getWrappedScope(factory.getAutoScope((SharedResourcesBroker)broker, broker.getConfigView(null, key, factory.getName())));
            }
        });
        return this.getScoped(factory, key, selectedScope, broker);
    }

    <T, K extends SharedResourceKey> SharedResourceFactoryResponse<T> getScopedFromCache(final SharedResourceFactory<T, K, S> factory, final @Nonnull K key, final @Nonnull ScopeWrapper<S> scope, final SharedResourcesBrokerImpl<S> broker) throws ExecutionException {
        RawJobBrokerKey fullKey = new RawJobBrokerKey(scope, factory.getName(), key);
        Object obj = this.sharedResourceCache.get((Object)fullKey, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return factory.createResource(broker.getScopedView(scope.getType()), broker.getConfigView(scope.getType(), key, factory.getName()));
            }
        });
        return (SharedResourceFactoryResponse)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <T, K extends SharedResourceKey> T getScoped(SharedResourceFactory<T, K, S> factory, @Nonnull K key, @Nonnull ScopeWrapper<S> scope, SharedResourcesBrokerImpl<S> broker) throws ExecutionException {
        SharedResourceFactory<T, K, S> currentFactory = factory;
        K currentKey = key;
        ScopeWrapper<S> currentScope = scope;
        SharedResourceFactoryResponse<T> obj = this.getScopedFromCache(currentFactory, currentKey, currentScope, broker);
        while (true) {
            if (obj instanceof ResourceCoordinate) {
                ResourceCoordinate resourceCoordinate = (ResourceCoordinate)obj;
                if (!SharedResourcesBrokerUtils.isScopeTypeAncestor(currentScope.getType(), ((ResourceCoordinate)obj).getScope())) {
                    throw new RuntimeException(String.format("%s returned an invalid coordinate: scope %s is not an ancestor of %s.", currentFactory.getName(), ((ResourceCoordinate)obj).getScope(), currentScope.getType()));
                }
                try {
                    obj = this.getScopedFromCache(resourceCoordinate.getFactory(), resourceCoordinate.getKey(), broker.getWrappedScope(resourceCoordinate.getScope()), broker);
                }
                catch (NoSuchScopeException nsse) {
                    throw new RuntimeException(String.format("%s returned an invalid coordinate: scope %s is not available.", factory.getName(), resourceCoordinate.getScope().name()), nsse);
                }
            }
            if (!(obj instanceof ResourceEntry)) throw new RuntimeException(String.format("Invalid response from %s: %s.", factory.getName(), obj.getClass()));
            Object resource = ((ResourceEntry)obj).getResourceIfValid();
            if (resource != null) {
                return (T)resource;
            }
            Lock lock = (Lock)this.invalidationLock.get(key);
            try {
                lock.lock();
                RawJobBrokerKey fullKey = new RawJobBrokerKey(currentScope, currentFactory.getName(), currentKey);
                this.safeInvalidate(fullKey);
                obj = this.getScopedFromCache(currentFactory, currentKey, currentScope, broker);
                continue;
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
    }

    <T, K extends SharedResourceKey> void put(SharedResourceFactory<T, K, S> factory, @Nonnull K key, @Nonnull ScopeWrapper<S> scope, T instance) {
        RawJobBrokerKey fullKey = new RawJobBrokerKey(scope, factory.getName(), key);
        this.sharedResourceCache.put((Object)fullKey, new ResourceInstance<T>(instance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeInvalidate(RawJobBrokerKey key) {
        Lock lock = (Lock)this.invalidationLock.get((Object)key);
        lock.lock();
        try {
            Object obj = this.sharedResourceCache.getIfPresent((Object)key);
            if (obj != null && obj instanceof ResourceEntry && !((ResourceEntry)obj).isValid()) {
                this.sharedResourceCache.invalidate((Object)key);
                ((ResourceEntry)obj).onInvalidate();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void close(ScopeWrapper<S> scope) throws IOException {
        ArrayList exceptionsList = Lists.newArrayList();
        ArrayList awaitShutdown = Lists.newArrayList();
        for (Map.Entry entry : Maps.filterKeys((Map)this.sharedResourceCache.asMap(), (Predicate)new ScopeIsAncestorFilter(scope)).entrySet()) {
            this.sharedResourceCache.invalidate(entry.getKey());
            if (!(entry.getValue() instanceof ResourceInstance)) continue;
            Object obj = ((ResourceInstance)entry.getValue()).getResource();
            try {
                SharedResourcesBrokerUtils.shutdownObject(obj, log);
            }
            catch (Throwable t) {
                exceptionsList.add(t);
            }
            if (!(obj instanceof Service)) continue;
            awaitShutdown.add((Service)obj);
        }
        for (Service service : awaitShutdown) {
            try {
                service.awaitTerminated(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                log.error("Failed to shutdown {}.", (Object)service);
            }
        }
        if (exceptionsList.size() > 0) {
            log.error(exceptionsList.stream().map(Throwables::getStackTraceAsString).collect(Collectors.joining("\n")));
        }
    }

    private class ScopeIsAncestorFilter
    implements Predicate<RawJobBrokerKey> {
        private final ScopeWrapper<S> scope;

        public boolean apply(RawJobBrokerKey input) {
            if (this.scope == null) {
                return true;
            }
            if (input.getScope() == null) {
                return false;
            }
            return SharedResourcesBrokerUtils.isScopeAncestor(input.getScope(), this.scope);
        }

        @ConstructorProperties(value={"scope"})
        public ScopeIsAncestorFilter(ScopeWrapper<S> scope) {
            this.scope = scope;
        }
    }

    class RawJobBrokerKey {
        private final ScopeWrapper<S> scope;
        private final String factoryName;
        private final SharedResourceKey key;

        @ConstructorProperties(value={"scope", "factoryName", "key"})
        public RawJobBrokerKey(ScopeWrapper<S> scope, String factoryName, SharedResourceKey key) {
            this.scope = scope;
            this.factoryName = factoryName;
            this.key = key;
        }

        public ScopeWrapper<S> getScope() {
            return this.scope;
        }

        public String getFactoryName() {
            return this.factoryName;
        }

        public SharedResourceKey getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RawJobBrokerKey)) {
                return false;
            }
            RawJobBrokerKey other = (RawJobBrokerKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ScopeWrapper this$scope = this.getScope();
            ScopeWrapper other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
                return false;
            }
            String this$factoryName = this.getFactoryName();
            String other$factoryName = other.getFactoryName();
            if (this$factoryName == null ? other$factoryName != null : !this$factoryName.equals(other$factoryName)) {
                return false;
            }
            SharedResourceKey this$key = this.getKey();
            SharedResourceKey other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RawJobBrokerKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScopeWrapper $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
            String $factoryName = this.getFactoryName();
            result = result * 59 + ($factoryName == null ? 43 : $factoryName.hashCode());
            SharedResourceKey $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultBrokerCache.RawJobBrokerKey(scope=" + this.getScope() + ", factoryName=" + this.getFactoryName() + ", key=" + this.getKey() + ")";
        }
    }
}

