/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.google.common.base.Strings;
import java.net.URI;
import org.apache.gobblin.util.ClustersNames;
import org.apache.gobblin.util.limiter.broker.SharedLimiterKey;

public class FileSystemLimiterKey
extends SharedLimiterKey {
    public static final String RESOURCE_LIMITED_PREFIX = "filesystem";
    private final URI uri;
    public final String serviceName;

    public FileSystemLimiterKey(URI uri) {
        this(uri, null);
    }

    public FileSystemLimiterKey(URI uri, String serviceName) {
        super("filesystem/" + FileSystemLimiterKey.getFSIdentifier(uri) + (Strings.isNullOrEmpty((String)serviceName) ? "" : "/" + serviceName));
        this.uri = uri;
        this.serviceName = serviceName;
    }

    private static String getFSIdentifier(URI uri) {
        return ClustersNames.getInstance().getClusterName(uri.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileSystemLimiterKey that = (FileSystemLimiterKey)o;
        return this.uri.equals(that.uri);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.uri.hashCode();
        return result;
    }
}

