/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Id {
    public static final String SEPARATOR = "_";
    private static final Joiner JOINER = Joiner.on((String)"_").skipNulls();
    static final Pattern PATTERN = Pattern.compile("([^_]+)_(.+)_(\\d+)");
    private String name;
    private Long sequence;

    public Id(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name is null or empty.");
        this.name = name;
    }

    public Id(String name, long sequence) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name is null or empty.");
        this.name = name;
        this.sequence = sequence;
    }

    protected abstract String getPrefix();

    public String get(EnumSet<Parts> parts) {
        Object[] values = new Object[3];
        if (parts.contains((Object)Parts.PREFIX)) {
            values[0] = this.getPrefix();
        }
        if (parts.contains((Object)Parts.NAME)) {
            values[1] = this.name;
        }
        if (parts.contains((Object)Parts.SEQUENCE)) {
            values[2] = this.sequence;
        }
        return JOINER.join(values);
    }

    public String toString() {
        return this.get(Parts.ALL);
    }

    public static Id parse(String id) {
        Matcher matcher = PATTERN.matcher(id);
        if (matcher.find()) {
            if ("job".equals(matcher.group(1))) {
                return new Job(matcher.group(2), matcher.group(3));
            }
            if ("task".equals(matcher.group(1))) {
                return new Task(matcher.group(2), matcher.group(3));
            }
            if ("multitask".equals(matcher.group(1))) {
                return new MultiTask(matcher.group(2), matcher.group(3));
            }
        }
        throw new RuntimeException("Invalid id: " + id);
    }

    public String getName() {
        return this.name;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public static class MultiTask
    extends Id {
        public static final String PREFIX = "multitask";

        private MultiTask(String name) {
            super(name);
        }

        private MultiTask(String name, int sequence) {
            super(name, sequence);
        }

        private MultiTask(String name, String sequence) {
            super(name, Integer.parseInt(sequence));
        }

        @Override
        protected String getPrefix() {
            return PREFIX;
        }

        public static MultiTask create(String name) {
            return new MultiTask(name);
        }

        public static MultiTask create(String name, int sequence) {
            return new MultiTask(name, sequence);
        }
    }

    public static class Task
    extends Id {
        public static final String PREFIX = "task";

        private Task(String name) {
            super(name);
        }

        private Task(String name, int sequence) {
            super(name, sequence);
        }

        private Task(String name, String sequence) {
            super(name, Integer.parseInt(sequence));
        }

        @Override
        protected String getPrefix() {
            return PREFIX;
        }

        public static Task create(String name) {
            return new Task(name);
        }

        public static Task create(String name, int sequence) {
            return new Task(name, sequence);
        }
    }

    public static class Job
    extends Id {
        public static final String PREFIX = "job";

        private Job(String name) {
            super(name);
        }

        private Job(String name, long sequence) {
            super(name, sequence);
        }

        private Job(String name, String sequence) {
            super(name, Long.parseLong(sequence));
        }

        @Override
        protected String getPrefix() {
            return PREFIX;
        }

        public static Job create(String name) {
            return new Job(name);
        }

        public static Job create(String name, long sequence) {
            return new Job(name, sequence);
        }
    }

    public static enum Parts {
        PREFIX,
        NAME,
        SEQUENCE;

        public static final EnumSet<Parts> INSTANCE_NAME;
        public static final EnumSet<Parts> ALL;

        static {
            INSTANCE_NAME = EnumSet.of(NAME, SEQUENCE);
            ALL = EnumSet.allOf(Parts.class);
        }
    }
}

