/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.PackagedTemplatesJobCatalogDecorator;
import org.apache.gobblin.runtime.job_spec.JobSpecResolver;
import org.apache.gobblin.runtime.template.ResourceBasedJobTemplate;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PullFileLoader;
import org.apache.gobblin.util.filesystem.PathAlterationListener;
import org.apache.gobblin.util.filesystem.PathAlterationObserver;
import org.apache.gobblin.util.filesystem.PathAlterationObserverScheduler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerUtils.class);
    public static final String JOB_PROPS_FILE_EXTENSION = "properties";

    public static List<Properties> loadGenericJobConfigs(Properties sysProps, JobSpecResolver resolver) throws ConfigurationException, IOException {
        Path rootPath = new Path(sysProps.getProperty("jobconf.fullyQualifiedPath"));
        PullFileLoader loader = new PullFileLoader(rootPath, rootPath.getFileSystem(new Configuration()), SchedulerUtils.getJobConfigurationFileExtensions(sysProps), (Collection)PullFileLoader.DEFAULT_HOCON_PULL_FILE_EXTENSIONS);
        Config sysConfig = ConfigUtils.propertiesToConfig((Properties)sysProps);
        List configs = loader.loadPullFilesRecursively(rootPath, sysConfig, true);
        ArrayList jobConfigs = Lists.newArrayListWithCapacity((int)configs.size());
        for (Config config : configs) {
            try {
                jobConfigs.add(SchedulerUtils.resolveTemplate(ConfigUtils.configToProperties((Config)config), resolver));
            }
            catch (IOException ioe) {
                LOGGER.error("Could not parse job config at " + ConfigUtils.getString((Config)config, (String)"job.config.path", (String)"Unknown path"), (Throwable)ioe);
            }
        }
        return jobConfigs;
    }

    public static List<Properties> loadGenericJobConfigs(Properties sysProps, Path commonPropsPath, Path jobConfigPathDir, JobSpecResolver resolver) throws ConfigurationException, IOException {
        PullFileLoader loader = new PullFileLoader(jobConfigPathDir, jobConfigPathDir.getFileSystem(new Configuration()), SchedulerUtils.getJobConfigurationFileExtensions(sysProps), (Collection)PullFileLoader.DEFAULT_HOCON_PULL_FILE_EXTENSIONS);
        Config sysConfig = ConfigUtils.propertiesToConfig((Properties)sysProps);
        List configs = loader.loadPullFilesRecursively(commonPropsPath.getParent(), sysConfig, true);
        ArrayList jobConfigs = Lists.newArrayListWithCapacity((int)configs.size());
        for (Config config : configs) {
            try {
                jobConfigs.add(SchedulerUtils.resolveTemplate(ConfigUtils.configToProperties((Config)config), resolver));
            }
            catch (IOException ioe) {
                LOGGER.error("Could not parse job config at " + ConfigUtils.getString((Config)config, (String)"job.config.path", (String)"Unknown path"), (Throwable)ioe);
            }
        }
        return jobConfigs;
    }

    public static Properties loadGenericJobConfig(Properties sysProps, Path jobConfigPath, Path jobConfigPathDir, JobSpecResolver resolver) throws ConfigurationException, IOException {
        PullFileLoader loader = new PullFileLoader(jobConfigPathDir, jobConfigPathDir.getFileSystem(new Configuration()), SchedulerUtils.getJobConfigurationFileExtensions(sysProps), (Collection)PullFileLoader.DEFAULT_HOCON_PULL_FILE_EXTENSIONS);
        Config sysConfig = ConfigUtils.propertiesToConfig((Properties)sysProps);
        Config config = loader.loadPullFile(jobConfigPath, sysConfig, true);
        return SchedulerUtils.resolveTemplate(ConfigUtils.configToProperties((Config)config), resolver);
    }

    public static void addPathAlterationObserver(PathAlterationObserverScheduler monitor, PathAlterationListener listener, Path rootDirPath) throws IOException {
        PathAlterationObserver observer = new PathAlterationObserver(rootDirPath);
        observer.addListener(listener);
        monitor.addObserver(observer);
    }

    private static Set<String> getJobConfigurationFileExtensions(Properties properties) {
        Iterable jobConfigFileExtensionsIterable = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)properties.getProperty("jobconf.extensions", "pull,job"));
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)jobConfigFileExtensionsIterable, (Function)new Function<String, String>(){

            public String apply(String input) {
                return null != input ? input.toLowerCase() : "";
            }
        }));
    }

    private static Properties resolveTemplate(Properties jobProps, JobSpecResolver resolver) throws IOException {
        if (!jobProps.containsKey("job.template")) {
            return jobProps;
        }
        try {
            JobSpec.Builder jobSpecBuilder = JobSpec.builder().withConfig(ConfigUtils.propertiesToConfig((Properties)jobProps));
            ResourceBasedJobTemplate jobTemplate = ResourceBasedJobTemplate.forResourcePath(jobProps.getProperty("job.template"), new PackagedTemplatesJobCatalogDecorator());
            jobSpecBuilder.withTemplate(jobTemplate);
            return resolver.resolveJobSpec(jobSpecBuilder.build()).getConfigAsProperties();
        }
        catch (URISyntaxException | JobTemplate.TemplateException | SpecNotFoundException exc) {
            throw new IOException(exc);
        }
    }
}

