/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.MultiContextIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterException;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterUtils;
import org.apache.gobblin.service.ExecutionStatus;
import org.apache.gobblin.service.monitoring.FlowStatus;
import org.apache.gobblin.service.monitoring.JobStatus;
import org.apache.gobblin.service.monitoring.LatestFlowExecutionIdTracker;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobStatusRetriever
implements LatestFlowExecutionIdTracker {
    private static final Logger log = LoggerFactory.getLogger(JobStatusRetriever.class);
    public static final String EVENT_NAME_FIELD = "eventName";
    public static final String NA_KEY = "NA";
    protected final MetricContext metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)ConfigFactory.empty()), this.getClass());
    protected final Boolean dagManagerEnabled;
    private final MultiContextIssueRepository issueRepository;

    protected JobStatusRetriever(boolean dagManagerEnabled, MultiContextIssueRepository issueRepository) {
        this.issueRepository = Objects.requireNonNull(issueRepository);
        this.dagManagerEnabled = dagManagerEnabled;
    }

    public abstract Iterator<JobStatus> getJobStatusesForFlowExecution(String var1, String var2, long var3);

    public abstract Iterator<JobStatus> getJobStatusesForFlowExecution(String var1, String var2, long var3, String var5, String var6);

    public abstract List<FlowStatus> getFlowStatusesForFlowGroupExecutions(String var1, int var2);

    @Override
    public long getLatestExecutionIdForFlow(String flowName, String flowGroup) {
        List<Long> lastKExecutionIds = this.getLatestExecutionIdsForFlow(flowName, flowGroup, 1);
        return lastKExecutionIds != null && !lastKExecutionIds.isEmpty() ? lastKExecutionIds.get(0) : -1L;
    }

    public Iterator<JobStatus> getLatestJobStatusByFlowNameAndGroup(String flowName, String flowGroup) {
        long latestExecutionId = this.getLatestExecutionIdForFlow(flowName, flowGroup);
        return latestExecutionId == -1L ? Collections.emptyIterator() : this.getJobStatusesForFlowExecution(flowName, flowGroup, latestExecutionId);
    }

    protected JobStatus getJobStatus(State jobState) {
        String flowGroup = this.getFlowGroup(jobState);
        String flowName = this.getFlowName(jobState);
        long flowExecutionId = this.getFlowExecutionId(jobState);
        String jobName = this.getJobName(jobState);
        String jobGroup = this.getJobGroup(jobState);
        String jobTag = jobState.getProp("jobTag");
        long jobExecutionId = this.getJobExecutionId(jobState);
        String eventName = jobState.getProp(EVENT_NAME_FIELD);
        long orchestratedTime = Long.parseLong(jobState.getProp("jobOrchestratedTime", "0"));
        long startTime = Long.parseLong(jobState.getProp("jobStartTime", "0"));
        long endTime = Long.parseLong(jobState.getProp("jobEndTime", "0"));
        String message = jobState.getProp("message", "");
        String lowWatermark = jobState.getProp("lowWatermark", "");
        String highWatermark = jobState.getProp("highWatermark", "");
        long processedCount = Long.parseLong(jobState.getProp("processedCount", "0"));
        int maxAttempts = Integer.parseInt(jobState.getProp("maxAttempts", "1"));
        int currentAttempts = Integer.parseInt(jobState.getProp("currentAttempts", "1"));
        int currentGeneration = Integer.parseInt(jobState.getProp("currentGeneration", "1"));
        boolean shouldRetry = Boolean.parseBoolean(jobState.getProp("shouldRetry", "false"));
        int progressPercentage = jobState.getPropAsInt("jobCompletionPercentage", 0);
        long lastProgressEventTime = jobState.getPropAsLong("jobLastProgressEventTime", 0L);
        String contextId = TroubleshooterUtils.getContextIdForJob(jobState.getProperties());
        Supplier jobIssues = Suppliers.memoize(() -> {
            List<Issue> issues;
            try {
                issues = this.issueRepository.getAll(contextId);
            }
            catch (TroubleshooterException e) {
                log.warn("Cannot retrieve job issues", (Throwable)e);
                issues = Collections.emptyList();
            }
            return issues;
        });
        return JobStatus.builder().flowName(flowName).flowGroup(flowGroup).flowExecutionId(flowExecutionId).jobName(jobName).jobGroup(jobGroup).jobTag(jobTag).jobExecutionId(jobExecutionId).eventName(eventName).lowWatermark(lowWatermark).highWatermark(highWatermark).orchestratedTime(orchestratedTime).startTime(startTime).endTime(endTime).message(message).processedCount(processedCount).maxAttempts(maxAttempts).currentAttempts(currentAttempts).currentGeneration(currentGeneration).shouldRetry(shouldRetry).progressPercentage(progressPercentage).lastProgressEventTime(lastProgressEventTime).issues((Supplier<List<Issue>>)jobIssues).build();
    }

    protected final String getFlowGroup(State jobState) {
        return jobState.getProp("flowGroup");
    }

    protected final String getFlowName(State jobState) {
        return jobState.getProp("flowName");
    }

    protected final long getFlowExecutionId(State jobState) {
        return Long.parseLong(jobState.getProp("flowExecutionId"));
    }

    protected final String getJobGroup(State jobState) {
        return jobState.getProp("jobGroup");
    }

    protected final String getJobName(State jobState) {
        return jobState.getProp("jobName");
    }

    protected final long getJobExecutionId(State jobState) {
        return Long.parseLong(jobState.getProp("jobExecutionId", "0"));
    }

    protected Iterator<JobStatus> asJobStatuses(List<State> jobStatusStates) {
        return jobStatusStates.stream().map(this::getJobStatus).iterator();
    }

    protected List<FlowStatus> asFlowStatuses(List<FlowExecutionJobStateGrouping> flowExecutionGroupings) {
        return flowExecutionGroupings.stream().map(exec -> {
            ImmutableList jobStatuses = ImmutableList.copyOf(this.asJobStatuses(exec.getJobStates().stream().sorted(Comparator.comparing(this::getJobGroup).thenComparing(this::getJobName).thenComparing(this::getJobExecutionId)).collect(Collectors.toList())));
            return new FlowStatus(exec.getFlowName(), exec.getFlowGroup(), exec.getFlowExecutionId(), jobStatuses.iterator(), JobStatusRetriever.getFlowStatusFromJobStatuses(this.dagManagerEnabled, jobStatuses.iterator()));
        }).collect(Collectors.toList());
    }

    protected List<FlowExecutionJobStateGrouping> groupByFlowExecutionAndRetainLatest(String flowGroup, List<State> jobStatusStates, int maxCountPerFlowName) {
        Map<String, Map<Long, List<State>>> statesByFlowExecutionIdByName = jobStatusStates.stream().collect(Collectors.groupingBy(this::getFlowName, Collectors.groupingBy(this::getFlowExecutionId)));
        return statesByFlowExecutionIdByName.entrySet().stream().sorted(Map.Entry.comparingByKey()).flatMap(flowNameEntry -> {
            String flowName = (String)flowNameEntry.getKey();
            Map statesByFlowExecutionIdForName = (Map)flowNameEntry.getValue();
            List executionIds = Ordering.natural().greatestOf(statesByFlowExecutionIdForName.keySet(), maxCountPerFlowName);
            return executionIds.stream().map(executionId -> new FlowExecutionJobStateGrouping(flowGroup, flowName, (long)executionId, (List)statesByFlowExecutionIdForName.get(executionId)));
        }).collect(Collectors.toList());
    }

    public abstract StateStore<State> getStateStore();

    public static boolean isFlowStatus(JobStatus jobStatus) {
        return jobStatus.getJobName() != null && jobStatus.getJobGroup() != null && jobStatus.getJobName().equals(NA_KEY) && jobStatus.getJobGroup().equals(NA_KEY);
    }

    public static ExecutionStatus getFlowStatusFromJobStatuses(boolean dagManagerEnabled, Iterator<JobStatus> jobStatusIterator) {
        ExecutionStatus flowExecutionStatus = ExecutionStatus.$UNKNOWN;
        if (dagManagerEnabled) {
            while (jobStatusIterator.hasNext()) {
                JobStatus jobStatus = jobStatusIterator.next();
                if (!JobStatusRetriever.isFlowStatus(jobStatus)) continue;
                flowExecutionStatus = ExecutionStatus.valueOf((String)jobStatus.getEventName());
            }
        } else {
            HashSet<ExecutionStatus> jobStatuses = new HashSet<ExecutionStatus>();
            while (jobStatusIterator.hasNext()) {
                JobStatus jobStatus = jobStatusIterator.next();
                if (JobStatusRetriever.isFlowStatus(jobStatus)) continue;
                jobStatuses.add(ExecutionStatus.valueOf((String)jobStatus.getEventName()));
            }
            ImmutableList statusesInDescendingSalience = ImmutableList.of((Object)ExecutionStatus.FAILED, (Object)ExecutionStatus.CANCELLED, (Object)ExecutionStatus.RUNNING, (Object)ExecutionStatus.ORCHESTRATED, (Object)ExecutionStatus.COMPLETE);
            flowExecutionStatus = statusesInDescendingSalience.stream().filter(jobStatuses::contains).findFirst().orElse(ExecutionStatus.$UNKNOWN);
        }
        return flowExecutionStatus;
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public Boolean getDagManagerEnabled() {
        return this.dagManagerEnabled;
    }

    protected static class FlowExecutionJobStateGrouping {
        private final String flowGroup;
        private final String flowName;
        private final long flowExecutionId;
        private final List<State> jobStates;

        public FlowExecutionJobStateGrouping(String flowGroup, String flowName, long flowExecutionId, List<State> jobStates) {
            this.flowGroup = flowGroup;
            this.flowName = flowName;
            this.flowExecutionId = flowExecutionId;
            this.jobStates = jobStates;
        }

        public String getFlowGroup() {
            return this.flowGroup;
        }

        public String getFlowName() {
            return this.flowName;
        }

        public long getFlowExecutionId() {
            return this.flowExecutionId;
        }

        public List<State> getJobStates() {
            return this.jobStates;
        }
    }
}

