/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.util.TaskMetrics;

public class ForkMetrics
extends GobblinMetrics {
    private static final String FORK_METRICS_BRANCH_NAME_KEY = "forkBranchName";

    protected ForkMetrics(TaskState taskState, int index) {
        super(ForkMetrics.name(taskState, index), TaskMetrics.get(taskState).getMetricContext(), ForkMetrics.getForkMetricsTags((State)taskState, index));
    }

    public static ForkMetrics get(final TaskState taskState, final int index) {
        return (ForkMetrics)GOBBLIN_METRICS_REGISTRY.getOrCreate(ForkMetrics.name(taskState, index), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new ForkMetrics(taskState, index);
            }
        });
    }

    private static String getForkMetricsId(State state, int index) {
        return state.getProp("fork.branch.name." + index, "fork_" + index);
    }

    private static List<Tag<?>> getForkMetricsTags(State state, int index) {
        return ImmutableList.of((Object)new Tag(FORK_METRICS_BRANCH_NAME_KEY, (Object)ForkMetrics.getForkMetricsId(state, index)));
    }

    protected static String name(TaskState taskState, int index) {
        return "gobblin.metrics." + taskState.getJobId() + "." + taskState.getTaskId() + "." + ForkMetrics.getForkMetricsId((State)taskState, index);
    }
}

