/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.IssueEventBuilder;
import org.apache.gobblin.runtime.troubleshooter.MultiContextIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterException;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterUtils;
import org.apache.gobblin.runtime.util.GsonUtils;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobIssueEventHandler {
    private static final Logger log = LoggerFactory.getLogger(JobIssueEventHandler.class);
    public static final String CONFIG_PREFIX = "gobblin.troubleshooter.jobIssueEventHandler.";
    public static final String LOG_RECEIVED_EVENTS = "gobblin.troubleshooter.jobIssueEventHandler.logReceivedEvents";
    private static final Logger issueLogger = LoggerFactory.getLogger((String)"org.apache.gobblin.runtime.troubleshooter.JobIssueLogger");
    private final MultiContextIssueRepository issueRepository;
    private final boolean logReceivedEvents;

    @Inject
    public JobIssueEventHandler(MultiContextIssueRepository issueRepository, Config config) {
        this(issueRepository, ConfigUtils.getBoolean((Config)config, (String)LOG_RECEIVED_EVENTS, (boolean)true));
    }

    public JobIssueEventHandler(MultiContextIssueRepository issueRepository, boolean logReceivedEvents) {
        this.issueRepository = Objects.requireNonNull(issueRepository);
        this.logReceivedEvents = logReceivedEvents;
    }

    public void processEvent(GobblinTrackingEvent event) {
        String contextId;
        if (!IssueEventBuilder.isIssueEvent(event)) {
            return;
        }
        try {
            Properties metadataProperties = new Properties();
            metadataProperties.putAll((Map<?, ?>)event.getMetadata());
            contextId = TroubleshooterUtils.getContextIdForJob(metadataProperties);
        }
        catch (Exception ex) {
            log.warn("Failed to extract context id from Gobblin tracking event with timestamp " + event.getTimestamp(), (Throwable)ex);
            return;
        }
        IssueEventBuilder issueEvent = IssueEventBuilder.fromEvent(event);
        try {
            this.issueRepository.put(contextId, issueEvent.getIssue());
        }
        catch (TroubleshooterException e) {
            log.warn(String.format("Failed to save issue to repository. Issue time: %s, code: %s", issueEvent.getIssue().getTime(), issueEvent.getIssue().getCode()), (Throwable)e);
        }
        if (this.logReceivedEvents) {
            this.logEvent(issueEvent);
        }
    }

    private void logEvent(IssueEventBuilder issueEvent) {
        ImmutableMap metadata = issueEvent.getMetadata();
        JobIssueLogEntry logEntry = new JobIssueLogEntry();
        logEntry.issue = issueEvent.getIssue();
        logEntry.flowGroup = (String)metadata.getOrDefault((Object)"flowGroup", null);
        logEntry.flowName = (String)metadata.getOrDefault((Object)"flowName", null);
        logEntry.flowExecutionId = (String)metadata.getOrDefault((Object)"flowExecutionId", null);
        logEntry.jobName = (String)metadata.getOrDefault((Object)"jobName", null);
        String serializedIssueEvent = GsonUtils.GSON_WITH_DATE_HANDLING.toJson((Object)logEntry);
        issueLogger.info(serializedIssueEvent);
    }

    private static class JobIssueLogEntry {
        String flowName;
        String flowGroup;
        String flowExecutionId;
        String jobName;
        Issue issue;

        private JobIssueLogEntry() {
        }
    }
}

