/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import com.typesafe.config.Config;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.gobblin.util.ConfigUtils;

public class AutomaticTroubleshooterConfig {
    private final boolean disabled;
    private final boolean disableEventReporting;
    private int inMemoryRepositoryMaxSize;

    @Inject
    public AutomaticTroubleshooterConfig(Config config) {
        Objects.requireNonNull(config, "Config cannot be null");
        this.disabled = ConfigUtils.getBoolean((Config)config, (String)"gobblin.troubleshooter.disabled", (boolean)false);
        this.disableEventReporting = ConfigUtils.getBoolean((Config)config, (String)"gobblin.troubleshooter.disableEventReporting", (boolean)false);
        this.inMemoryRepositoryMaxSize = ConfigUtils.getInt((Config)config, (String)"gobblin.troubleshooter.inMemoryIssueRepository.maxSize", (Integer)100);
    }

    private static int $default$inMemoryRepositoryMaxSize() {
        return 100;
    }

    public static AutomaticTroubleshooterConfigBuilder builder() {
        return new AutomaticTroubleshooterConfigBuilder();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDisableEventReporting() {
        return this.disableEventReporting;
    }

    public int getInMemoryRepositoryMaxSize() {
        return this.inMemoryRepositoryMaxSize;
    }

    public AutomaticTroubleshooterConfig(boolean disabled, boolean disableEventReporting, int inMemoryRepositoryMaxSize) {
        this.disabled = disabled;
        this.disableEventReporting = disableEventReporting;
        this.inMemoryRepositoryMaxSize = inMemoryRepositoryMaxSize;
    }

    public static class AutomaticTroubleshooterConfigBuilder {
        private boolean disabled;
        private boolean disableEventReporting;
        private boolean inMemoryRepositoryMaxSize$set;
        private int inMemoryRepositoryMaxSize$value;

        AutomaticTroubleshooterConfigBuilder() {
        }

        public AutomaticTroubleshooterConfigBuilder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public AutomaticTroubleshooterConfigBuilder disableEventReporting(boolean disableEventReporting) {
            this.disableEventReporting = disableEventReporting;
            return this;
        }

        public AutomaticTroubleshooterConfigBuilder inMemoryRepositoryMaxSize(int inMemoryRepositoryMaxSize) {
            this.inMemoryRepositoryMaxSize$value = inMemoryRepositoryMaxSize;
            this.inMemoryRepositoryMaxSize$set = true;
            return this;
        }

        public AutomaticTroubleshooterConfig build() {
            int inMemoryRepositoryMaxSize$value = this.inMemoryRepositoryMaxSize$value;
            if (!this.inMemoryRepositoryMaxSize$set) {
                inMemoryRepositoryMaxSize$value = AutomaticTroubleshooterConfig.$default$inMemoryRepositoryMaxSize();
            }
            return new AutomaticTroubleshooterConfig(this.disabled, this.disableEventReporting, inMemoryRepositoryMaxSize$value);
        }

        public String toString() {
            return "AutomaticTroubleshooterConfig.AutomaticTroubleshooterConfigBuilder(disabled=" + this.disabled + ", disableEventReporting=" + this.disableEventReporting + ", inMemoryRepositoryMaxSize$value=" + this.inMemoryRepositoryMaxSize$value + ")";
        }
    }
}

