/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.messaging;

import java.io.IOException;
import org.apache.gobblin.runtime.messaging.DynamicWorkUnitConsumer;
import org.apache.gobblin.runtime.messaging.MessageBuffer;
import org.apache.gobblin.runtime.messaging.data.DynamicWorkUnitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWorkUnitProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicWorkUnitConsumer.class);
    private final MessageBuffer<DynamicWorkUnitMessage> messageBuffer;

    public DynamicWorkUnitProducer(MessageBuffer<DynamicWorkUnitMessage> messageBuffer) {
        this.messageBuffer = messageBuffer;
    }

    public boolean produce(DynamicWorkUnitMessage message) throws IOException {
        LOG.debug("Sending message over message buffer, messageBuffer={}, message={}", (Object)this.messageBuffer.getClass().getSimpleName(), (Object)message);
        try {
            this.messageBuffer.publish(message);
            return true;
        }
        catch (IOException e) {
            LOG.debug("Failed to publish message. exception=", (Throwable)e);
            return false;
        }
    }
}

