/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.mapreduce;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.RejectedExecutionException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.runtime.AbstractTaskStateTracker;
import org.apache.gobblin.runtime.Task;
import org.apache.gobblin.runtime.util.JobMetrics;
import org.apache.gobblin.runtime.util.MetricGroup;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.hadoop.mapreduce.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRTaskStateTracker
extends AbstractTaskStateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(MRTaskStateTracker.class);
    private final Mapper.Context context;

    public MRTaskStateTracker(Mapper.Context context) {
        super(context.getConfiguration(), LOG);
        this.context = context;
    }

    @Override
    public void registerNewTask(Task task) {
        try {
            if (GobblinMetrics.isEnabled((State)task.getTaskState().getWorkunit())) {
                this.scheduleTaskMetricsUpdater(new MRTaskMetricsUpdater(task, this.context), task);
            }
        }
        catch (RejectedExecutionException ree) {
            LOG.error(String.format("Scheduling of task state reporter for task %s was rejected", task.getTaskId()));
        }
    }

    @Override
    public void onTaskRunCompletion(Task task) {
        task.markTaskCompletion();
    }

    @Override
    public void onTaskCommitCompletion(Task task) {
        WorkUnit workUnit = task.getTaskState().getWorkunit();
        if (GobblinMetrics.isEnabled((State)workUnit)) {
            task.updateRecordMetrics();
            task.updateByteMetrics();
            if (workUnit.getPropAsBoolean("mr.report.metrics.as.counters", false)) {
                this.updateCounters(task);
            }
        }
        LOG.info(String.format("Task %s completed running in %dms with state %s", task.getTaskId(), task.getTaskState().getTaskDuration(), task.getTaskState().getWorkingState()));
    }

    private void updateCounters(Task task) {
        this.updateCounters(task, MetricGroupFilter.JOB);
        this.updateCounters(task, MetricGroupFilter.TASK);
    }

    private void updateCounters(Task task, MetricGroupFilter filter) {
        SortedMap counters = JobMetrics.get(null, task.getJobId()).getMetricContext().getCounters((MetricFilter)filter);
        if (counters != null) {
            for (Map.Entry entry : counters.entrySet()) {
                this.context.getCounter(filter.getGroupName(), (String)entry.getKey()).setValue(((Counter)entry.getValue()).getCount());
            }
        }
    }

    private static enum MetricGroupFilter implements MetricFilter
    {
        JOB{

            @Override
            public String getGroupName() {
                return MetricGroup.JOB.toString();
            }
        }
        ,
        TASK{

            @Override
            public String getGroupName() {
                return MetricGroup.TASK.toString();
            }
        };


        public boolean matches(String name, Metric metric) {
            return name.startsWith(this.toString());
        }

        public abstract String getGroupName();
    }

    private class MRTaskMetricsUpdater
    extends AbstractTaskStateTracker.TaskMetricsUpdater {
        private final Mapper.Context context;

        MRTaskMetricsUpdater(Task task, Mapper.Context context) {
            super(task);
            this.context = context;
        }

        @Override
        protected void updateTaskMetrics() {
            super.updateTaskMetrics();
            WorkUnit workUnit = this.task.getTaskState().getWorkunit();
            if (GobblinMetrics.isEnabled((State)workUnit) && workUnit.getPropAsBoolean("mr.report.metrics.as.counters", false)) {
                MRTaskStateTracker.this.updateCounters(this.task);
            }
            this.context.progress();
        }
    }
}

