/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.InMemoryJobCatalog;
import org.apache.gobblin.runtime.template.ResourceBasedJobTemplate;
import org.apache.gobblin.util.Decorator;

public class PackagedTemplatesJobCatalogDecorator
implements Decorator,
JobCatalogWithTemplates {
    public static final String RESOURCE = "resource";
    public static final String CLASS = "class";
    private final JobCatalog underlying;

    public PackagedTemplatesJobCatalogDecorator() {
        this(new InMemoryJobCatalog());
    }

    public PackagedTemplatesJobCatalogDecorator(JobCatalog underlying) {
        this.underlying = underlying != null ? underlying : new InMemoryJobCatalog();
    }

    public Object getDecoratedObject() {
        return this.underlying;
    }

    @Override
    public JobTemplate getTemplate(URI uri) throws SpecNotFoundException, JobTemplate.TemplateException {
        if (RESOURCE.equals(uri.getScheme())) {
            try {
                URI actualResourceUri = new URI(uri.getPath().substring(1));
                return ResourceBasedJobTemplate.forURI(actualResourceUri, this);
            }
            catch (URISyntaxException use) {
                throw new RuntimeException("Error when computing resource path.", use);
            }
            catch (IOException ioe) {
                throw new SpecNotFoundException(uri, (Throwable)ioe);
            }
        }
        if (CLASS.equals(uri.getScheme())) {
            try {
                return (JobTemplate)Class.forName(uri.getAuthority()).newInstance();
            }
            catch (ReflectiveOperationException roe) {
                throw new SpecNotFoundException(uri, (Throwable)roe);
            }
        }
        if (this.underlying != null && this.underlying instanceof JobCatalogWithTemplates) {
            JobTemplate template = ((JobCatalogWithTemplates)this.underlying).getTemplate(uri);
            if (template == null) {
                throw new SpecNotFoundException(uri);
            }
            return template;
        }
        throw new SpecNotFoundException(uri);
    }

    @Override
    public Collection<JobTemplate> getAllTemplates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<JobSpec> getJobs() {
        return this.underlying.getJobs();
    }

    @Override
    public Iterator<JobSpec> getJobSpecIterator() {
        return this.underlying.getJobSpecIterator();
    }

    @Override
    public JobCatalog.StandardMetrics getMetrics() {
        return this.underlying.getMetrics();
    }

    @Override
    public Collection<StandardMetricsBridge.StandardMetrics> getStandardMetricsCollection() {
        return this.underlying.getStandardMetricsCollection();
    }

    @Override
    public JobSpec getJobSpec(URI uri) throws JobSpecNotFoundException {
        return this.underlying.getJobSpec(uri);
    }

    @Override
    public void addListener(JobCatalogListener jobListener) {
        this.underlying.addListener(jobListener);
    }

    @Override
    public void registerWeakJobCatalogListener(JobCatalogListener jobListener) {
        this.underlying.registerWeakJobCatalogListener(jobListener);
    }

    @Override
    public void removeListener(JobCatalogListener jobListener) {
        this.underlying.removeListener(jobListener);
    }

    public MetricContext getMetricContext() {
        return this.underlying.getMetricContext();
    }

    public boolean isInstrumentationEnabled() {
        return this.underlying.isInstrumentationEnabled();
    }

    public List<Tag<?>> generateTags(State arg0) {
        return this.underlying.generateTags(arg0);
    }

    public void switchMetricContext(List<Tag<?>> arg0) {
        this.underlying.switchMetricContext(arg0);
    }

    public void switchMetricContext(MetricContext arg0) {
        this.underlying.switchMetricContext(arg0);
    }
}

