/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.gobblin.fsm.FiniteStateMachine;
import org.apache.gobblin.fsm.StateWithCallbacks;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.job.JobInterruptionPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinJobFiniteStateMachine
extends FiniteStateMachine<JobFSMState> {
    private static final Logger log = LoggerFactory.getLogger(GobblinJobFiniteStateMachine.class);
    private final JobState jobState;
    private final RunnableWithIoException interruptGracefully;
    private final RunnableWithIoException killJob;

    private GobblinJobFiniteStateMachine(JobState jobState, RunnableWithIoException interruptGracefully, RunnableWithIoException killJob) {
        super(GobblinJobFiniteStateMachine.buildAllowedTransitions(), (Set)Sets.newHashSet((Object[])new JobFSMState[]{new JobFSMState(StateType.CANCELLED)}), (Object)new JobFSMState(StateType.FAILED), (Object)new JobFSMState(StateType.PREPARING));
        if (jobState == null) {
            throw new IllegalArgumentException("Job state is required.");
        }
        this.jobState = jobState;
        this.interruptGracefully = interruptGracefully;
        this.killJob = killJob;
    }

    public JobFSMState getEndStateForType(StateType stateType) {
        switch (stateType) {
            case RUNNING: {
                return new RunnableState();
            }
        }
        return new JobFSMState(stateType);
    }

    private void interruptRunningJob() {
        block19: {
            log.info("Interrupting job execution.");
            try (FiniteStateMachine.Transition transition = this.startTransition(this.getEndStateForType(StateType.INTERRUPTED));){
                try {
                    this.interruptGracefully.run();
                }
                catch (IOException ioe) {
                    transition.changeEndState((Object)this.getEndStateForType(StateType.FAILED));
                }
            }
            catch (FiniteStateMachine.UnallowedTransitionException exc) {
                log.error("Cannot interrupt job.", (Throwable)exc);
            }
            catch (InterruptedException | FiniteStateMachine.FailedTransitionCallbackException exc) {
                log.error("Cannot finish graceful job interruption. Killing job.", exc);
                try {
                    this.killJob.run();
                }
                catch (IOException ioe) {
                    log.error("Failed to kill job.", (Throwable)ioe);
                }
                if (!(exc instanceof FiniteStateMachine.FailedTransitionCallbackException)) break block19;
                ((FiniteStateMachine.FailedTransitionCallbackException)exc).getTransition().switchEndStateToErrorState();
                ((FiniteStateMachine.FailedTransitionCallbackException)exc).getTransition().closeWithoutCallbacks();
            }
        }
    }

    private static SetMultimap<JobFSMState, JobFSMState> buildAllowedTransitions() {
        HashMultimap transitions = HashMultimap.create();
        transitions.put((Object)new JobFSMState(StateType.PREPARING), (Object)new JobFSMState(StateType.RUNNING));
        transitions.put((Object)new JobFSMState(StateType.PREPARING), (Object)new JobFSMState(StateType.FAILED));
        transitions.put((Object)new JobFSMState(StateType.PREPARING), (Object)new JobFSMState(StateType.INTERRUPTED));
        transitions.put((Object)new JobFSMState(StateType.RUNNING), (Object)new JobFSMState(StateType.SUCCESS));
        transitions.put((Object)new JobFSMState(StateType.RUNNING), (Object)new JobFSMState(StateType.FAILED));
        transitions.put((Object)new JobFSMState(StateType.RUNNING), (Object)new JobFSMState(StateType.INTERRUPTED));
        return transitions;
    }

    public static GobblinJobFiniteStateMachineBuilder builder() {
        return new GobblinJobFiniteStateMachineBuilder();
    }

    public static class GobblinJobFiniteStateMachineBuilder {
        private JobState jobState;
        private RunnableWithIoException interruptGracefully;
        private RunnableWithIoException killJob;

        GobblinJobFiniteStateMachineBuilder() {
        }

        public GobblinJobFiniteStateMachineBuilder jobState(JobState jobState) {
            this.jobState = jobState;
            return this;
        }

        public GobblinJobFiniteStateMachineBuilder interruptGracefully(RunnableWithIoException interruptGracefully) {
            this.interruptGracefully = interruptGracefully;
            return this;
        }

        public GobblinJobFiniteStateMachineBuilder killJob(RunnableWithIoException killJob) {
            this.killJob = killJob;
            return this;
        }

        public GobblinJobFiniteStateMachine build() {
            return new GobblinJobFiniteStateMachine(this.jobState, this.interruptGracefully, this.killJob);
        }

        public String toString() {
            return "GobblinJobFiniteStateMachine.GobblinJobFiniteStateMachineBuilder(jobState=" + this.jobState + ", interruptGracefully=" + this.interruptGracefully + ", killJob=" + this.killJob + ")";
        }
    }

    @FunctionalInterface
    public static interface RunnableWithIoException {
        public void run() throws IOException;
    }

    private class RunnableState
    extends JobFSMState
    implements StateWithCallbacks<JobFSMState> {
        private final JobInterruptionPredicate jobInterruptionPredicate;

        public RunnableState() {
            super(StateType.RUNNING);
            this.jobInterruptionPredicate = GobblinJobFiniteStateMachine.this.interruptGracefully == null ? null : new JobInterruptionPredicate(GobblinJobFiniteStateMachine.this.jobState, () -> GobblinJobFiniteStateMachine.this.interruptRunningJob(), false);
        }

        public void onEnterState(@Nullable JobFSMState previousState) {
            if (this.jobInterruptionPredicate != null) {
                this.jobInterruptionPredicate.startAsync();
            }
        }

        public void onLeaveState(JobFSMState nextState) {
            if (this.jobInterruptionPredicate != null) {
                this.jobInterruptionPredicate.stopAsync();
            }
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class JobFSMState {
        private final StateType stateType;

        private JobFSMState(StateType stateType) {
            this.stateType = stateType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobFSMState)) {
                return false;
            }
            JobFSMState other = (JobFSMState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StateType this$stateType = this.getStateType();
            StateType other$stateType = other.getStateType();
            return !(this$stateType == null ? other$stateType != null : !((Object)((Object)this$stateType)).equals((Object)other$stateType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobFSMState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StateType $stateType = this.getStateType();
            result = result * 59 + ($stateType == null ? 43 : ((Object)((Object)$stateType)).hashCode());
            return result;
        }

        public String toString() {
            return "GobblinJobFiniteStateMachine.JobFSMState(stateType=" + (Object)((Object)this.getStateType()) + ")";
        }

        public StateType getStateType() {
            return this.stateType;
        }
    }

    public static enum StateType {
        PREPARING,
        RUNNING,
        INTERRUPTED,
        CANCELLED,
        SUCCESS,
        FAILED;

    }
}

