/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalog;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.spec_catalog.AddSpecResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MutableSpecCatalog
extends SpecCatalog {
    public Map<String, AddSpecResponse> put(Spec var1) throws Throwable;

    public void remove(URI var1, Properties var2) throws SpecNotFoundException;

    public static class MutableStandardMetrics
    extends SpecCatalog.StandardMetrics {
        private static final Logger log = LoggerFactory.getLogger(MutableStandardMetrics.class);
        public static final String TIME_FOR_SPEC_CATALOG_REMOVE = "timeForSpecCatalogRemove";
        public static final String TIME_FOR_SPEC_CATALOG_PUT = "timeForSpecCatalogPut";
        private final ContextAwareTimer timeForSpecCatalogPut;
        private final ContextAwareTimer timeForSpecCatalogRemove;

        public MutableStandardMetrics(SpecCatalog catalog, Optional<Config> sysConfig) {
            super(catalog, sysConfig);
            this.timeForSpecCatalogPut = catalog.getMetricContext().contextAwareTimer(TIME_FOR_SPEC_CATALOG_PUT, (long)this.timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.timeForSpecCatalogRemove = catalog.getMetricContext().contextAwareTimer(TIME_FOR_SPEC_CATALOG_REMOVE, (long)this.timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.contextAwareMetrics.add(this.timeForSpecCatalogPut);
            this.contextAwareMetrics.add(this.timeForSpecCatalogRemove);
        }

        public void updatePutSpecTime(long startTime) {
            log.info("updatePutSpecTime...");
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeForSpecCatalogPut), (long)(System.currentTimeMillis() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        public void updateRemoveSpecTime(long startTime) {
            log.info("updateRemoveSpecTime...");
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeForSpecCatalogRemove), (long)(System.currentTimeMillis() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        public ContextAwareTimer getTimeForSpecCatalogPut() {
            return this.timeForSpecCatalogPut;
        }

        public ContextAwareTimer getTimeForSpecCatalogRemove() {
            return this.timeForSpecCatalogRemove;
        }
    }
}

