/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.template.ResourceBasedJobTemplate;
import org.apache.gobblin.runtime.template.StaticJobTemplate;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class JobSpec
implements Configurable,
Spec {
    private static final Logger log = LoggerFactory.getLogger(JobSpec.class);
    private static final long serialVersionUID = 6074793380396465963L;
    URI uri;
    String version;
    String description;
    Config config;
    Properties configAsProperties;
    Optional<URI> templateURI;
    transient Optional<JobTemplate> jobTemplate;
    Map<String, String> metadata;
    private static final String IN_MEMORY_TEMPLATE_URI = "inmemory";

    public static Builder builder(URI jobSpecUri) {
        return new Builder(jobSpecUri);
    }

    public static Builder builder(String jobSpecUri) {
        return new Builder(jobSpecUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(URI catalogURI, Properties jobProps) {
        String name = JobState.getJobNameFromProps(jobProps);
        String group = JobState.getJobGroupFromProps(jobProps);
        if (null == group) {
            group = "default";
        }
        try {
            URI jobURI = new URI(catalogURI.getScheme(), catalogURI.getAuthority(), "/" + group + "/" + name, null);
            Builder builder = new Builder(jobURI).withConfigAsProperties(jobProps);
            String descr = JobState.getJobDescriptionFromProps(jobProps);
            if (null != descr) {
                builder.withDescription(descr);
            }
            return builder;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create a JobSpec URI: " + e, e);
        }
    }

    public String toShortString() {
        return this.getUri().toString() + "/" + this.getVersion();
    }

    public String toLongString() {
        return this.getUri().toString() + "/" + this.getVersion() + "[" + this.getDescription() + "]";
    }

    public String toString() {
        return this.toShortString();
    }

    public URI getUri() {
        return this.uri;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.uri);
        stream.writeObject(this.version);
        stream.writeObject(this.description);
        stream.writeObject(this.templateURI.isPresent() ? this.templateURI.get() : null);
        stream.writeObject(this.configAsProperties);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.uri = (URI)stream.readObject();
        this.version = (String)stream.readObject();
        this.description = (String)stream.readObject();
        this.templateURI = Optional.fromNullable((Object)((URI)stream.readObject()));
        this.configAsProperties = (Properties)stream.readObject();
        this.config = ConfigUtils.propertiesToConfig((Properties)this.configAsProperties);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Properties getConfigAsProperties() {
        return this.configAsProperties;
    }

    public Optional<URI> getTemplateURI() {
        return this.templateURI;
    }

    public Optional<JobTemplate> getJobTemplate() {
        return this.jobTemplate;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setConfigAsProperties(Properties configAsProperties) {
        this.configAsProperties = configAsProperties;
    }

    public void setTemplateURI(Optional<URI> templateURI) {
        this.templateURI = templateURI;
    }

    public void setJobTemplate(Optional<JobTemplate> jobTemplate) {
        this.jobTemplate = jobTemplate;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobSpec)) {
            return false;
        }
        JobSpec other = (JobSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Properties this$configAsProperties = this.getConfigAsProperties();
        Properties other$configAsProperties = other.getConfigAsProperties();
        if (this$configAsProperties == null ? other$configAsProperties != null : !((Object)this$configAsProperties).equals(other$configAsProperties)) {
            return false;
        }
        Optional<URI> this$templateURI = this.getTemplateURI();
        Optional<URI> other$templateURI = other.getTemplateURI();
        if (this$templateURI == null ? other$templateURI != null : !this$templateURI.equals(other$templateURI)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Properties $configAsProperties = this.getConfigAsProperties();
        result = result * 59 + ($configAsProperties == null ? 43 : ((Object)$configAsProperties).hashCode());
        Optional<URI> $templateURI = this.getTemplateURI();
        result = result * 59 + ($templateURI == null ? 43 : $templateURI.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public JobSpec(URI uri, String version, String description, Config config, Properties configAsProperties, Optional<URI> templateURI, Optional<JobTemplate> jobTemplate, Map<String, String> metadata) {
        this.uri = uri;
        this.version = version;
        this.description = description;
        this.config = config;
        this.configAsProperties = configAsProperties;
        this.templateURI = templateURI;
        this.jobTemplate = jobTemplate;
        this.metadata = metadata;
    }

    public static class Builder {
        public static final String DEFAULT_JOB_CATALOG_SCHEME = "gobblin-job";
        @VisibleForTesting
        private Optional<Config> config = Optional.absent();
        private Optional<Properties> configAsProperties = Optional.absent();
        private Optional<URI> uri;
        private String version = "1";
        private Optional<String> description = Optional.absent();
        private Optional<URI> jobCatalogURI = Optional.absent();
        private Optional<URI> templateURI = Optional.absent();
        private Optional<JobTemplate> jobTemplate = Optional.absent();
        private Optional<Map> metadata = Optional.absent();

        public Builder(URI jobSpecUri) {
            Preconditions.checkNotNull((Object)jobSpecUri);
            this.uri = Optional.of((Object)jobSpecUri);
        }

        public Builder(String jobSpecUri) {
            Preconditions.checkNotNull((Object)jobSpecUri);
            Preconditions.checkNotNull((Object)jobSpecUri);
            try {
                this.uri = Optional.of((Object)new URI(jobSpecUri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid JobSpec config: " + e, e);
            }
        }

        public Builder() {
            this.uri = Optional.absent();
        }

        public JobSpec build() {
            Preconditions.checkNotNull(this.uri);
            Preconditions.checkNotNull((Object)this.version);
            return new JobSpec(this.getURI(), this.getVersion(), this.getDescription(), this.getConfig(), this.getConfigAsProperties(), this.getTemplateURI(), this.getTemplate(), this.getMetadata());
        }

        public Builder withJobCatalogURI(URI jobCatalogURI) {
            this.jobCatalogURI = Optional.of((Object)jobCatalogURI);
            return this;
        }

        public Builder withJobCatalogURI(String jobCatalogURI) {
            try {
                this.jobCatalogURI = Optional.of((Object)new URI(jobCatalogURI));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to set job catalog URI: " + e, e);
            }
            return this;
        }

        public URI getDefaultJobCatalogURI() {
            try {
                return new URI(DEFAULT_JOB_CATALOG_SCHEME, null, "/", null, null);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected exception: " + e, e);
            }
        }

        public URI getJobCatalogURI() {
            if (!this.jobCatalogURI.isPresent()) {
                this.jobCatalogURI = Optional.of((Object)this.getDefaultJobCatalogURI());
            }
            return (URI)this.jobCatalogURI.get();
        }

        public URI getDefaultURI() {
            URI jobCatalogURI = this.getJobCatalogURI();
            Config jobCfg = this.getConfig();
            String name = jobCfg.hasPath("job.name") ? jobCfg.getString("job.name") : "default";
            String group = jobCfg.hasPath("job.group") ? jobCfg.getString("job.group") : "default";
            try {
                return new URI(jobCatalogURI.getScheme(), jobCatalogURI.getAuthority(), "/" + group + "/" + name, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to create default JobSpec URI:" + e, e);
            }
        }

        public URI getURI() {
            if (!this.uri.isPresent()) {
                this.uri = Optional.of((Object)this.getDefaultURI());
            }
            return (URI)this.uri.get();
        }

        public Builder withVersion(String version) {
            Preconditions.checkNotNull((Object)version);
            this.version = version;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder withDescription(String jobDescription) {
            Preconditions.checkNotNull((Object)jobDescription);
            this.description = Optional.of((Object)jobDescription);
            return this;
        }

        public String getDefaultDescription() {
            Config jobConf = this.getConfig();
            return jobConf.hasPath("job.description") ? jobConf.getString("job.description") : "Gobblin job " + this.getURI();
        }

        public String getDescription() {
            if (!this.description.isPresent()) {
                this.description = Optional.of((Object)this.getDefaultDescription());
            }
            return (String)this.description.get();
        }

        public Config getDefaultConfig() {
            return ConfigFactory.empty();
        }

        public Config getConfig() {
            if (!this.config.isPresent()) {
                this.config = this.configAsProperties.isPresent() ? Optional.of((Object)ConfigUtils.propertiesToTypedConfig((Properties)((Properties)this.configAsProperties.get()), (Optional)Optional.absent())) : Optional.of((Object)this.getDefaultConfig());
            }
            return (Config)this.config.get();
        }

        public Builder withConfig(Config jobConfig) {
            Preconditions.checkNotNull((Object)jobConfig);
            this.config = Optional.of((Object)jobConfig);
            return this;
        }

        public Properties getConfigAsProperties() {
            if (!this.configAsProperties.isPresent()) {
                this.configAsProperties = Optional.of((Object)ConfigUtils.configToProperties((Config)((Config)this.config.get())));
            }
            return (Properties)this.configAsProperties.get();
        }

        public Builder withConfigAsProperties(Properties jobConfig) {
            Preconditions.checkNotNull((Object)jobConfig);
            this.configAsProperties = Optional.of((Object)jobConfig);
            return this;
        }

        public Optional<URI> getTemplateURI() {
            return this.templateURI;
        }

        public Builder withTemplate(URI templateURI) {
            Preconditions.checkNotNull((Object)templateURI);
            this.templateURI = Optional.of((Object)templateURI);
            return this;
        }

        public Builder withResourceTemplates(List<URI> templateURIs) {
            try {
                ArrayList<JobTemplate> templates = new ArrayList<JobTemplate>(templateURIs.size());
                for (URI uri : templateURIs) {
                    templates.add(ResourceBasedJobTemplate.forResourcePath(uri.getPath()));
                }
                this.jobTemplate = Optional.of((Object)new StaticJobTemplate(new URI(JobSpec.IN_MEMORY_TEMPLATE_URI), "", "", ConfigFactory.empty(), templates));
            }
            catch (IOException | URISyntaxException | JobTemplate.TemplateException | SpecNotFoundException e) {
                throw new RuntimeException("Fatal exception: Templates couldn't be resolved properly, ", e);
            }
            return this;
        }

        public Optional<JobTemplate> getTemplate() {
            return this.jobTemplate;
        }

        public Builder withTemplate(JobTemplate template) {
            Preconditions.checkNotNull((Object)template);
            this.jobTemplate = Optional.of((Object)template);
            return this;
        }

        public Map getDefaultMetadata() {
            log.debug("Job Spec Verb is not provided, using type 'UNKNOWN'.");
            return ImmutableMap.of((Object)"Verb", (Object)SpecExecutor.Verb.UNKNOWN.name());
        }

        public Map getMetadata() {
            if (!this.metadata.isPresent()) {
                this.metadata = Optional.of((Object)this.getDefaultMetadata());
            }
            return (Map)this.metadata.get();
        }

        public Builder withMetadata(Map<String, String> metadata) {
            Preconditions.checkNotNull(metadata);
            this.metadata = Optional.of(metadata);
            return this;
        }
    }
}

