/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.codahale.metrics.Gauge;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.Executor;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.metrics.ContextAwareCounter;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobExecutionLauncher;
import org.apache.gobblin.runtime.api.JobLifecycleListenersContainer;
import org.apache.gobblin.runtime.api.JobSpecScheduler;
import org.apache.gobblin.runtime.api.MutableJobCatalog;

@Alpha
public interface GobblinInstanceDriver
extends Service,
JobLifecycleListenersContainer,
GobblinInstanceEnvironment {
    public JobCatalog getJobCatalog();

    public MutableJobCatalog getMutableJobCatalog();

    public JobSpecScheduler getJobScheduler();

    public JobExecutionLauncher getJobLauncher();

    public StandardMetrics getMetrics();

    public static class StandardMetrics
    extends Service.Listener {
        public static final String INSTANCE_NAME_TAG = "instanceName";
        public static final String UPTIMEMS_NAME = "uptimeMs";
        public static final String UPFLAG_NAME = "upFlag";
        public static final String NUM_UNCLASSIFIED_ERRORS_NAME = "numUnclassifiedErrors";
        private final ContextAwareGauge<Long> uptimeMs;
        private final ContextAwareGauge<Integer> upFlag;
        private final ContextAwareCounter numUnclassifiedErrors;
        private long startTimeMs;

        public StandardMetrics(final GobblinInstanceDriver parent) {
            this.uptimeMs = parent.getMetricContext().newContextAwareGauge(UPTIMEMS_NAME, (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return startTimeMs > 0L ? System.currentTimeMillis() - startTimeMs : 0L;
                }
            });
            this.upFlag = parent.getMetricContext().newContextAwareGauge(UPFLAG_NAME, (Gauge)new Gauge<Integer>(){

                public Integer getValue() {
                    switch (parent.state()) {
                        case RUNNING: {
                            return 1;
                        }
                        case FAILED: {
                            return -1;
                        }
                    }
                    return 0;
                }
            });
            this.numUnclassifiedErrors = parent.getMetricContext().contextAwareCounter(NUM_UNCLASSIFIED_ERRORS_NAME);
            parent.addListener(this, new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            });
        }

        public void running() {
            this.startTimeMs = System.currentTimeMillis();
        }

        public void terminated(Service.State from) {
            this.startTimeMs = 0L;
        }

        public void failed(Service.State from, Throwable failure) {
            this.startTimeMs = 0L;
        }

        public ContextAwareGauge<Long> getUptimeMs() {
            return this.uptimeMs;
        }

        public ContextAwareGauge<Integer> getUpFlag() {
            return this.upFlag;
        }

        public ContextAwareCounter getNumUnclassifiedErrors() {
            return this.numUnclassifiedErrors;
        }
    }
}

