/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.InfiniteSource;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.WorkUnitStreamSource;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.BasicWorkUnitStream;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.Decorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceDecorator<S, D>
implements WorkUnitStreamSource<S, D>,
Decorator {
    private static final Logger LOG = LoggerFactory.getLogger(SourceDecorator.class);
    private final Source<S, D> source;
    private final String jobId;
    private final Logger logger;

    public SourceDecorator(Source<S, D> source, String jobId, Logger logger) {
        this.source = source;
        this.jobId = jobId;
        this.logger = null != logger ? logger : LOG;
    }

    public List<WorkUnit> getWorkunits(SourceState state) {
        try {
            List workUnits = this.source.getWorkunits(state);
            if (workUnits == null) {
                return Collections.emptyList();
            }
            return workUnits;
        }
        catch (Throwable t) {
            this.logger.error("Failed to get work units for job " + this.jobId, t);
            return null;
        }
    }

    public EventBus getEventBus() {
        if (this.getDecoratedObject() instanceof InfiniteSource) {
            return ((InfiniteSource)this.getDecoratedObject()).getEventBus();
        }
        if (this.getDecoratedObject() instanceof SourceDecorator) {
            return ((SourceDecorator)this.getDecoratedObject()).getEventBus();
        }
        return null;
    }

    public WorkUnitStream getWorkunitStream(SourceState state) {
        try {
            if (this.source instanceof WorkUnitStreamSource) {
                return ((WorkUnitStreamSource)this.source).getWorkunitStream(state);
            }
            List workUnits = this.source.getWorkunits(state);
            if (workUnits == null) {
                workUnits = Collections.emptyList();
            }
            return new BasicWorkUnitStream.Builder(workUnits).build();
        }
        catch (Throwable t) {
            this.logger.error("Failed to get work units for job " + this.jobId, t);
            return null;
        }
    }

    public Extractor<S, D> getExtractor(WorkUnitState state) throws IOException {
        try {
            return this.source.getExtractor(state);
        }
        catch (Throwable t) {
            this.logger.error("Failed to get extractor for job " + this.jobId, t);
            Throwables.propagate((Throwable)t);
            return null;
        }
    }

    public void shutdown(SourceState state) {
        try {
            this.source.shutdown(state);
        }
        catch (Throwable t) {
            this.logger.error("Failed to shutdown source for job " + this.jobId, t);
        }
    }

    public Object getDecoratedObject() {
        return this.source;
    }

    public boolean isEarlyStopped() {
        return this.source.isEarlyStopped();
    }
}

