/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.service.ExecutionStatus;
import org.apache.gobblin.service.monitoring.FlowStatus;
import org.apache.gobblin.service.monitoring.JobStatus;
import org.apache.gobblin.service.monitoring.JobStatusRetriever;

@Alpha
public class FlowStatusGenerator {
    public static final List<String> FINISHED_STATUSES = Lists.newArrayList((Object[])new String[]{"FAILED", "COMPLETE", "CANCELLED"});
    public static final int MAX_LOOKBACK = 100;
    private final JobStatusRetriever jobStatusRetriever;

    @Inject
    public FlowStatusGenerator(JobStatusRetriever jobStatusRetriever) {
        this.jobStatusRetriever = jobStatusRetriever;
    }

    public List<FlowStatus> getLatestFlowStatus(String flowName, String flowGroup, int count, String tag) {
        List<Long> flowExecutionIds = this.jobStatusRetriever.getLatestExecutionIdsForFlow(flowName, flowGroup, count);
        if (flowExecutionIds == null || flowExecutionIds.isEmpty()) {
            return null;
        }
        return flowExecutionIds.stream().map(flowExecutionId -> this.getFlowStatus(flowName, flowGroup, (long)flowExecutionId, tag)).collect(Collectors.toList());
    }

    public List<FlowStatus> getLatestFlowStatus(String flowName, String flowGroup, int count, String tag, String executionStatus) {
        if (executionStatus == null) {
            return this.getLatestFlowStatus(flowName, flowGroup, count, tag);
        }
        List<FlowStatus> flowStatuses = this.getLatestFlowStatus(flowName, flowGroup, 100, tag);
        if (flowStatuses == null) {
            return null;
        }
        ArrayList<FlowStatus> matchingFlowStatuses = new ArrayList<FlowStatus>();
        for (FlowStatus flowStatus : flowStatuses) {
            if (matchingFlowStatuses.size() == count) {
                return matchingFlowStatuses;
            }
            if (!flowStatus.getFlowExecutionStatus().name().equals(executionStatus)) continue;
            matchingFlowStatuses.add(flowStatus);
        }
        return matchingFlowStatuses;
    }

    public FlowStatus getFlowStatus(String flowName, String flowGroup, long flowExecutionId, String tag) {
        ImmutableList jobStatuses = ImmutableList.copyOf(this.retainStatusOfAnyFlowOrJobMatchingTag(this.jobStatusRetriever.getJobStatusesForFlowExecution(flowName, flowGroup, flowExecutionId), tag));
        ExecutionStatus flowExecutionStatus = JobStatusRetriever.getFlowStatusFromJobStatuses(this.jobStatusRetriever.getDagManagerEnabled(), jobStatuses.iterator());
        return jobStatuses.iterator().hasNext() ? new FlowStatus(flowName, flowGroup, flowExecutionId, jobStatuses.iterator(), flowExecutionStatus) : null;
    }

    public List<FlowStatus> getFlowStatusesAcrossGroup(String flowGroup, int countPerFlowName, String tag) {
        List<FlowStatus> flowStatuses = this.jobStatusRetriever.getFlowStatusesForFlowGroupExecutions(flowGroup, countPerFlowName);
        return flowStatuses.stream().flatMap(fs -> {
            Iterator<JobStatus> filteredJobStatuses = this.retainStatusOfAnyFlowOrJobMatchingTag(fs.getJobStatusIterator(), tag);
            return filteredJobStatuses.hasNext() ? Stream.of(new FlowStatus(fs.getFlowName(), fs.getFlowGroup(), fs.getFlowExecutionId(), filteredJobStatuses, fs.getFlowExecutionStatus())) : Stream.empty();
        }).collect(Collectors.toList());
    }

    public boolean isFlowRunning(String flowName, String flowGroup) {
        List<FlowStatus> flowStatusList = this.getLatestFlowStatus(flowName, flowGroup, 1, null);
        if (flowStatusList == null || flowStatusList.isEmpty()) {
            return false;
        }
        FlowStatus flowStatus = flowStatusList.get(0);
        ExecutionStatus flowExecutionStatus = flowStatus.getFlowExecutionStatus();
        return !FINISHED_STATUSES.contains(flowExecutionStatus.name());
    }

    private Iterator<JobStatus> retainStatusOfAnyFlowOrJobMatchingTag(Iterator<JobStatus> jobStatuses, String tag) {
        Predicate matchesTag = js -> JobStatusRetriever.isFlowStatus(js) || js.getJobTag() != null && js.getJobTag().equals(tag);
        Predicate p = tag == null ? Predicates.alwaysTrue() : matchesTag;
        return Iterators.filter(jobStatuses, (Predicate)p);
    }
}

