/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.gobblin.runtime.troubleshooter.InMemoryIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.MultiContextIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterException;

@Singleton
public class InMemoryMultiContextIssueRepository
extends AbstractIdleService
implements MultiContextIssueRepository {
    private final LRUMap<String, InMemoryIssueRepository> contextIssues;
    private final Configuration configuration;

    public InMemoryMultiContextIssueRepository() {
        this(Configuration.builder().build());
    }

    @Inject
    public InMemoryMultiContextIssueRepository(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.contextIssues = new LRUMap(configuration.getMaxContextCount());
    }

    @Override
    public synchronized List<Issue> getAll(String contextId) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.getOrDefault((Object)contextId, null);
        if (issueRepository != null) {
            return issueRepository.getAll();
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized void put(String contextId, Issue issue) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.computeIfAbsent((Object)contextId, s -> new InMemoryIssueRepository(this.configuration.getMaxIssuesPerContext()));
        issueRepository.put(issue);
    }

    @Override
    public synchronized void put(String contextId, List<Issue> issues) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.computeIfAbsent((Object)contextId, s -> new InMemoryIssueRepository(this.configuration.getMaxIssuesPerContext()));
        issueRepository.put(issues);
    }

    @Override
    public synchronized void remove(String contextId, String issueCode) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.getOrDefault((Object)contextId, null);
        if (issueRepository != null) {
            issueRepository.remove(issueCode);
        }
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    public static class Configuration {
        private int maxContextCount;
        private int maxIssuesPerContext;

        @Inject
        public Configuration(Config innerConfig) {
            this();
            if (innerConfig.hasPath("gobblin.service.issueRepo.memory.maxContextCount")) {
                this.maxContextCount = innerConfig.getInt("gobblin.service.issueRepo.memory.maxContextCount");
            }
            if (innerConfig.hasPath("gobblin.service.issueRepo.memory.maxIssuesPerContext")) {
                this.maxIssuesPerContext = innerConfig.getInt("gobblin.service.issueRepo.memory.maxIssuesPerContext");
            }
        }

        private static int $default$maxContextCount() {
            return 100;
        }

        private static int $default$maxIssuesPerContext() {
            return 20;
        }

        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        public int getMaxContextCount() {
            return this.maxContextCount;
        }

        public int getMaxIssuesPerContext() {
            return this.maxIssuesPerContext;
        }

        public Configuration(int maxContextCount, int maxIssuesPerContext) {
            this.maxContextCount = maxContextCount;
            this.maxIssuesPerContext = maxIssuesPerContext;
        }

        public Configuration() {
            this.maxContextCount = Configuration.$default$maxContextCount();
            this.maxIssuesPerContext = Configuration.$default$maxIssuesPerContext();
        }

        public static class ConfigurationBuilder {
            private boolean maxContextCount$set;
            private int maxContextCount$value;
            private boolean maxIssuesPerContext$set;
            private int maxIssuesPerContext$value;

            ConfigurationBuilder() {
            }

            public ConfigurationBuilder maxContextCount(int maxContextCount) {
                this.maxContextCount$value = maxContextCount;
                this.maxContextCount$set = true;
                return this;
            }

            public ConfigurationBuilder maxIssuesPerContext(int maxIssuesPerContext) {
                this.maxIssuesPerContext$value = maxIssuesPerContext;
                this.maxIssuesPerContext$set = true;
                return this;
            }

            public Configuration build() {
                int maxContextCount$value = this.maxContextCount$value;
                if (!this.maxContextCount$set) {
                    maxContextCount$value = Configuration.$default$maxContextCount();
                }
                int maxIssuesPerContext$value = this.maxIssuesPerContext$value;
                if (!this.maxIssuesPerContext$set) {
                    maxIssuesPerContext$value = Configuration.$default$maxIssuesPerContext();
                }
                return new Configuration(maxContextCount$value, maxIssuesPerContext$value);
            }

            public String toString() {
                return "InMemoryMultiContextIssueRepository.Configuration.ConfigurationBuilder(maxContextCount$value=" + this.maxContextCount$value + ", maxIssuesPerContext$value=" + this.maxIssuesPerContext$value + ")";
            }
        }
    }
}

