/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SecureJobTemplate;
import org.apache.gobblin.runtime.template.InheritingJobTemplate;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticJobTemplate
extends InheritingJobTemplate
implements SecureJobTemplate {
    private static final Logger log = LoggerFactory.getLogger(StaticJobTemplate.class);
    public static final String SUPER_TEMPLATE_KEY = "gobblin.template.inherit";
    public static final String IS_SECURE_KEY = "gobblin.template.isSecure";
    public static final String SECURE_OVERRIDABLE_PROPERTIES_KEYS = "gobblin.template.secure.overridableProperties";
    private Config rawConfig;
    private Set<String> requiredAttributes;
    private final URI uri;
    private final String version;
    private final String description;
    private Collection<String> dependencies;

    public StaticJobTemplate(URI uri, String version, String description, Config config, JobCatalogWithTemplates catalog) throws JobTemplate.TemplateException {
        this(uri, version, description, config, StaticJobTemplate.getSuperTemplateUris(config), catalog);
    }

    public StaticJobTemplate(URI uri, String version, String description, Config config, List<JobTemplate> templates) {
        super(templates, false);
        this.uri = uri;
        this.version = version;
        this.rawConfig = config;
        this.description = description;
    }

    protected StaticJobTemplate(URI uri, String version, String description, Config config, List<URI> superTemplateUris, JobCatalogWithTemplates catalog) {
        super(superTemplateUris, catalog);
        this.uri = uri;
        this.version = version;
        this.description = description;
        this.rawConfig = config;
        this.requiredAttributes = config.hasPath("gobblin.template.required_attributes") ? new HashSet<String>(Arrays.asList(config.getString("gobblin.template.required_attributes").split(","))) : Sets.newHashSet();
        this.dependencies = config.hasPath("job.dependencies") ? Arrays.asList(config.getString("job.dependencies").split(",")) : new ArrayList<String>();
    }

    private static List<URI> getSuperTemplateUris(Config config) throws JobTemplate.TemplateException {
        if (config.hasPath(SUPER_TEMPLATE_KEY)) {
            ArrayList uris = Lists.newArrayList();
            for (String uriString : ConfigUtils.getStringList((Config)config, (String)SUPER_TEMPLATE_KEY)) {
                try {
                    uris.add(new URI(uriString));
                }
                catch (URISyntaxException use) {
                    throw new JobTemplate.TemplateException("Super template uri is malformed: " + uriString, use);
                }
            }
            return uris;
        }
        return Lists.newArrayList();
    }

    @Override
    protected Config getLocalRawTemplate() {
        return this.rawConfig;
    }

    @Override
    protected Collection<String> getLocallyRequiredConfigList() {
        return this.requiredAttributes;
    }

    @Override
    protected Config getLocallyResolvedConfig(Config userConfig) {
        Config filteredUserConfig = SecureJobTemplate.filterUserConfig(this, userConfig, log);
        return filteredUserConfig.withFallback((ConfigMergeable)this.rawConfig);
    }

    @Override
    public boolean isSecure() {
        return ConfigUtils.getBoolean((Config)this.rawConfig, (String)IS_SECURE_KEY, (boolean)false);
    }

    @Override
    public Collection<String> overridableProperties() {
        return this.isSecure() ? ConfigUtils.getStringList((Config)this.rawConfig, (String)SECURE_OVERRIDABLE_PROPERTIES_KEYS) : Collections.emptyList();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<String> getDependencies() {
        return this.dependencies;
    }
}

