/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_store;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecSearchObject;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.spec_store.MysqlBaseSpecStore;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSpecStore
extends MysqlBaseSpecStore {
    private static final Logger log = LoggerFactory.getLogger(MysqlSpecStore.class);
    public static final String CONFIG_PREFIX = "mysqlSpecStore";
    protected static final String SPECIFIC_INSERT_STATEMENT = "INSERT INTO %s (spec_uri, flow_group, flow_name, template_uri, user_to_proxy, source_identifier, destination_identifier, schedule, tag, isRunImmediately, owning_group, spec, spec_json) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE spec = VALUES(spec), spec_json = VALUES(spec_json)";
    private static final String SPECIFIC_GET_STATEMENT_BASE = "SELECT spec_uri, spec, spec_json FROM %s WHERE ";
    private static final String SPECIFIC_GET_ALL_STATEMENT = "SELECT spec_uri, spec, spec_json, modified_time FROM %s";
    private static final String SPECIFIC_GET_SPECS_BATCH_STATEMENT = "SELECT spec_uri, spec, spec_json, modified_time FROM %s ORDER BY spec_uri ASC LIMIT ? OFFSET ?";
    private static final String SPECIFIC_CREATE_TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS %s (spec_uri VARCHAR(" + FlowSpec.Utils.maxFlowSpecUriLength() + ") NOT NULL, flow_group VARCHAR(" + 128 + "), flow_name VARCHAR(" + 128 + "), template_uri VARCHAR(128), user_to_proxy VARCHAR(128), source_identifier VARCHAR(128), destination_identifier VARCHAR(128), schedule VARCHAR(128), tag VARCHAR(128) NOT NULL, modified_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, isRunImmediately BOOLEAN, timezone VARCHAR(128), owning_group VARCHAR(128), spec LONGBLOB, spec_json JSON, PRIMARY KEY (spec_uri))";

    public MysqlSpecStore(Config config, SpecSerDe specSerDe) throws IOException {
        super(config, specSerDe);
    }

    @Override
    protected String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    protected MysqlBaseSpecStore.SqlStatements createSqlStatements() {
        return new SpecificSqlStatements();
    }

    @Override
    public Collection<Spec> getSpecsImpl(SpecSearchObject specSearchObject) throws IOException {
        return this.withPreparedStatement(specSearchObject.augmentBaseGetStatement(this.sqlStatements.getStatementBase), statement -> {
            specSearchObject.completePreparedStatement((PreparedStatement)statement);
            return this.retrieveSpecs((PreparedStatement)statement);
        });
    }

    protected class SpecificSqlStatements
    extends MysqlBaseSpecStore.SqlStatements {
        protected SpecificSqlStatements() {
            super(MysqlSpecStore.this);
        }

        @Override
        public void completeInsertPreparedStatement(PreparedStatement statement, Spec spec, String tagValue) throws SQLException {
            FlowSpec flowSpec = (FlowSpec)spec;
            URI specUri = flowSpec.getUri();
            Config flowConfig = flowSpec.getConfig();
            String flowGroup = flowConfig.getString("flow.group");
            String flowName = flowConfig.getString("flow.name");
            String templateURI = new Gson().toJson(flowSpec.getTemplateURIs());
            String userToProxy = ConfigUtils.getString((Config)flowSpec.getConfig(), (String)"user.to.proxy", null);
            String sourceIdentifier = flowConfig.getString("gobblin.flow.sourceIdentifier");
            String destinationIdentifier = flowConfig.getString("gobblin.flow.destinationIdentifier");
            String schedule = ConfigUtils.getString((Config)flowConfig, (String)"job.schedule", null);
            String owningGroup = ConfigUtils.getString((Config)flowConfig, (String)"flow.owningGroup", null);
            boolean isRunImmediately = ConfigUtils.getBoolean((Config)flowConfig, (String)"flow.runImmediately", (boolean)false);
            int i = 0;
            statement.setString(++i, specUri.toString());
            statement.setString(++i, flowGroup);
            statement.setString(++i, flowName);
            statement.setString(++i, templateURI);
            statement.setString(++i, userToProxy);
            statement.setString(++i, sourceIdentifier);
            statement.setString(++i, destinationIdentifier);
            statement.setString(++i, schedule);
            statement.setString(++i, tagValue);
            statement.setBoolean(++i, isRunImmediately);
            statement.setString(++i, owningGroup);
            statement.setBlob(++i, new ByteArrayInputStream(MysqlSpecStore.this.specSerDe.serialize(flowSpec)));
            statement.setString(++i, new String(MysqlSpecStore.this.specSerDe.serialize(flowSpec), Charsets.UTF_8));
        }

        @Override
        public Spec extractSpec(ResultSet rs) throws SQLException, IOException {
            return rs.getString(3) == null ? MysqlSpecStore.this.specSerDe.deserialize(ByteStreams.toByteArray((InputStream)rs.getBlob(2).getBinaryStream())) : MysqlSpecStore.this.specSerDe.deserialize(rs.getString(3).getBytes(Charsets.UTF_8));
        }

        @Override
        public Spec extractSpecWithModificationTime(ResultSet rs) throws SQLException, IOException {
            Spec spec;
            Spec spec2 = spec = rs.getString(3) == null ? MysqlSpecStore.this.specSerDe.deserialize(ByteStreams.toByteArray((InputStream)rs.getBlob(2).getBinaryStream())) : MysqlSpecStore.this.specSerDe.deserialize(rs.getString(3).getBytes(Charsets.UTF_8));
            if (spec instanceof FlowSpec) {
                long timestamp = rs.getTimestamp("modified_time").getTime();
                FlowSpec flowSpec = (FlowSpec)spec;
                Properties properties = flowSpec.getConfigAsProperties();
                properties.setProperty("modified_time", String.valueOf(timestamp));
                return flowSpec;
            }
            return spec;
        }

        @Override
        protected String getTablelessInsertStatement() {
            return MysqlSpecStore.SPECIFIC_INSERT_STATEMENT;
        }

        @Override
        protected String getTablelessGetStatementBase() {
            return MysqlSpecStore.SPECIFIC_GET_STATEMENT_BASE;
        }

        @Override
        protected String getTablelessGetAllStatement() {
            return MysqlSpecStore.SPECIFIC_GET_ALL_STATEMENT;
        }

        @Override
        protected String getTablelessGetBatchStatement() {
            return MysqlSpecStore.SPECIFIC_GET_SPECS_BATCH_STATEMENT;
        }

        @Override
        protected String getTablelessCreateTableStatement() {
            return SPECIFIC_CREATE_TABLE_STATEMENT;
        }
    }
}

