/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.gobblin.runtime.api.JobSpec;

public class JobSpecSerializer
implements JsonSerializer<JobSpec> {
    public static final String JOB_SPEC_URI_KEY = "uri";
    public static final String JOB_SPEC_VERSION_KEY = "version";
    public static final String JOB_SPEC_DESCRIPTION_KEY = "description";
    public static final String JOB_SPEC_TEMPLATE_URI_KEY = "templateURI";
    public static final String JOB_SPEC_CONFIG_AS_PROPERTIES_KEY = "configAsProperties";

    public JsonElement serialize(JobSpec src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jobSpecJson = new JsonObject();
        jobSpecJson.add(JOB_SPEC_URI_KEY, context.serialize((Object)src.getUri()));
        jobSpecJson.add(JOB_SPEC_VERSION_KEY, context.serialize((Object)src.getVersion()));
        jobSpecJson.add(JOB_SPEC_DESCRIPTION_KEY, context.serialize((Object)src.getDescription()));
        jobSpecJson.add(JOB_SPEC_TEMPLATE_URI_KEY, src.getTemplateURI().isPresent() ? context.serialize(src.getTemplateURI().get()) : null);
        jobSpecJson.add(JOB_SPEC_CONFIG_AS_PROPERTIES_KEY, context.serialize((Object)src.getConfigAsProperties()));
        return jobSpecJson;
    }
}

