/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.common.base.Charsets;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializer;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecSerDeException;
import org.apache.gobblin.runtime.spec_serde.GsonSerDe;

public abstract class GenericGsonSpecSerDe<T extends Spec>
implements SpecSerDe {
    private final GsonSerDe<T> gsonSerDe;
    private final Class<T> specClass;

    protected GenericGsonSpecSerDe(Class<T> specClass, JsonSerializer<T> serializer, JsonDeserializer<T> deserializer) {
        this.specClass = specClass;
        this.gsonSerDe = new GsonSerDe<T>(specClass, serializer, deserializer);
    }

    @Override
    public byte[] serialize(Spec spec) throws SpecSerDeException {
        if (!this.specClass.isInstance(spec)) {
            throw new SpecSerDeException("Failed to serialize spec " + spec.getUri() + ", only " + this.specClass.getName() + " is supported");
        }
        try {
            return this.gsonSerDe.serialize(this.specClass.cast(spec)).getBytes(Charsets.UTF_8);
        }
        catch (JsonParseException e) {
            throw new SpecSerDeException(spec, (Throwable)e);
        }
    }

    @Override
    public Spec deserialize(byte[] spec) throws SpecSerDeException {
        try {
            return (Spec)this.gsonSerDe.deserialize(new String(spec, Charsets.UTF_8));
        }
        catch (JsonParseException e) {
            throw new SpecSerDeException(e);
        }
    }
}

